package com.biz.crm.kms.business.direct.product.sdk.service;

import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductUnitDto;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductUnitVo;

import java.util.List;

/**
 * 直营上架产品单位管理表(DirectProductUnit)表服务接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
public interface DirectProductUnitVoService {

  /**
   * 按directProductId集合查询选项列表
   *
   * @param directProductIds 企业产品与客户产品关系ID集合
   * @param orderType
   * @return DirectProductUnitVo
   */
  List<DirectProductUnitVo> findDirectProductIds(List<String> directProductIds, String orderType);

  /**
   * 批量创建
   *
   * @param dtoList
   */
  void createBatch(List<DirectProductUnitDto> dtoList);

  /**
   * 根据directProductId删除
   *
   * @param directProductId
   */
  void deleteByDirectProductId(String directProductId);

  /**
   * 根据ProductIdList删除
   *
   */
  void deleteByProductIdList(List<String> productIdList);
}
