package com.biz.crm.kms.business.direct.product.sdk.service;

import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;

import java.util.List;

/**
 * 直营上架产品管理表(directProduct)表服务接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
public interface DirectProductVoService {

  /**
   * 条件查询列表
   *
   * @param dto
   * @return
   */
  List<DirectProductVo> findByListConditions(DirectProductDto dto);
  /**
   * 按直营上架产品dto查询
   * 核心需要：传入ka产品集合查询，结果集包含对应的单位信息
   *
   * @param dto
   * @return
   */
  List<DirectProductVo> findByDirectProductDto(DirectProductDto dto);

  /**
   * 按系统编码查询详情
   *
   * @param directCode
   * @return
   */
  List<DirectProductVo> findByDirectCode(String directCode);

  /**
   * 按系统编码查询详情
   *
   * @param directCodes
   * @return
   */
  List<DirectProductVo> findByDirectCodes(List<String> directCodes);
  
  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  DirectProductVo findDetailById(String id);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  void create(DirectProductDto dto);

  /**
   * 批量创建(导入)
   * @param dtoList
   */
  void importBatch(List<DirectProductDto> dtoList);

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  void update(DirectProductDto dto);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 批量拉取 MDG 上架产品数据
   */
  void pullKmsDirectProductList(MasterDataMdgBaseDto dto);

  /**
   * 定时缓存主数据产品税率
   */
  void cacheProductTaxRate();
}
