package com.biz.crm.kms.business.direct.product.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 直营上架产品单位管理表Vo
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "直营上架产品单位管理表Vo")
public class DirectProductUnitVo extends UuidVo {

  /**
   * 企业产品与客户产品关系ID
   */
  @ApiModelProperty("企业产品与客户产品关系ID")
  private String directProductId;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 企业产品单位编码
   */
  @ApiModelProperty("企业产品单位编码")
  private String unitCode;

  /**
   * 企业产品单位名称
   */
  @ApiModelProperty("企业产品单位名称")
  private String unitName;

  /**
   * 企业单位数量
   */
  @ApiModelProperty("企业单位数量")
  private BigDecimal unitQuantity;

  /**
   * 客户产品单位编码
   */
  @ApiModelProperty("客户产品单位编码")
  private String kaUnitCode;

  /**
   * 商超单位数量
   */
  @ApiModelProperty("商超单位数量")
  private BigDecimal kaUnitQuantity;
}

