package com.biz.crm.kms.business.direct.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 系统vo
 *
 * @author songjingen
 * @date 2022/9/26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DirectDto", description = "系统Dto")
public class DirectDto extends TenantFlagOpDto {
  private static final long serialVersionUID = -2559992139232179428L;

  /**
   * 业态[数据字典:mdm_business_format]
   */
  @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
  private String businessFormatCode;

  /**
   * 业务单元
   */
  @ApiModelProperty(name = "业务单元")
  private String businessUnitCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  private String customerOrgName;

  /**
   * 关联商超编码
   */
  @ApiModelProperty("关联商超编码")
  private String supermarketCode;

  /**
   * 系统名称
   */
  @ApiModelProperty("系统名称")
  private String supermarketName;

  /**
   * 销售组织编码
   */
  @ApiModelProperty("销售组织编码")
  private String salesOrgCode;

  /**
   * 销售组织名称
   */
  @TableField(value = "sales_org_name")
  private String salesOrgName;

}
