package com.biz.crm.kms.business.direct.sdk.listener;

import com.biz.crm.kms.business.direct.sdk.dto.DirectLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 系统日志事件
 *
 * @author duyiran
 * @create 2022-11-04 16:51
 */
public interface DirectLogEventListener extends NebulaEvent {

    /**
     * 创建事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(DirectLogEventDto dto);

    /**
     * 删除事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(DirectLogEventDto dto);

    /**
     * 修改事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(DirectLogEventDto dto);

    /**
     * 启用事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(DirectLogEventDto dto);

    /**
     * 禁用事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(DirectLogEventDto dto);

}
