package com.biz.crm.kms.business.direct.sdk.listener;

import java.util.List;

/**
 * 系统操作监听器
 *
 * @author songjingen
 * @date 2022/9/27
 */
public interface DirectOperationListener {

  /**
   * 修改时，通知上层业务进行业务处理
   *
   * @param oldDirectCode 旧的系统编码
   * @param newDirectCode 新的系统编码
   */
  default void onUpdate(String oldDirectCode, String newDirectCode) {
  }

  /**
   * 启用时，通知上层业务进行业务处理
   *
   * @param directCodes 系统编码
   */
  void onEnable(List<String> directCodes);

  /**
   * 禁用时，通知上层业务进行业务处理
   *
   * @param directCodes 系统编码
   */
  void onDisable(List<String> directCodes);

  /**
   * 删除时，通知上层业务进行业务处理
   *
   * @param directCodes 系统编码
   */
  void onDelete(List<String> directCodes);
}
