package com.biz.crm.kms.business.direct.sdk.service;

import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;

import java.util.List;

/**
 * 系统voService
 *
 * @author songjingen
 * @date 2022/9/27
 */
public interface DirectVoService {

  List<DirectVo> findByDirectCodes(List<String> directCodes);

  DirectVo findByDirectCode(String directCode);

  /**
   * 查询全部系统数据
   * */
  List<DirectVo> findAllDirect();

  /**
   * 通过销售组织编码集合和商超编码集合查询系统
   * @param saleOrgCodes
   * @param superMarketCodes
   * @return
   */
  List<DirectVo> findBySaleOrgCodesAndSuperMarketCodes(List<String> saleOrgCodes,List<String> superMarketCodes);

  /**
   * 条件查询系统编码
   * @param businessUnitCode
   * @return
   */
  List<DirectVo> findDirectCodesByBusinessUnitCode (String businessUnitCode);
}
