package com.biz.crm.bussiness.direct.store.feign.feign;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.bussiness.direct.store.feign.feign.internal.DirectStoreFeignImpl;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(
        name = "${mdm.feign-client.name:crm-kms}",
        path = "crm-kms",
        fallbackFactory = DirectStoreFeignImpl.class)
public interface DirectStoreFeign {


    /**
     * 通过商超门店条件获取直营门店信息
     *
     * @param dto 参数dto
     * @return 直营门店信息
     */
    @PostMapping("/v1/directStore/directStore/findByDirectStoreConditionDto")
    Result<List<DirectStoreVo>> findByDirectStoreConditionDto(@RequestBody DirectStoreConditionDto dto);
}
