package com.biz.crm.kms.business.direct.store.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.local.service.DirectStoreService;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreDto;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 直营门店: DirectStore: 直营门店配置
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Slf4j
@RestController
@RequestMapping("/v1/directStore/directStore")
@Api(tags = "直营门店: DirectStore: 直营门店配置")
public class DirectStoreController {

  @Autowired
  private DirectStoreService directStoreService;

  /**
   * 新增直营门店信息
   *
   * @param dto 参数dto
   * @return 新增直营门店数据
   */
  @ApiOperation(value = "新增直营门店")
  @PostMapping("")
  public Result<DirectStoreEntity> create(@RequestBody DirectStoreDto dto) {
    try {
      return Result.ok(this.directStoreService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新直营门店信息
   *
   * @param dto 参数dto
   * @return 更新后直营门店数据
   */
  @ApiOperation(value = "更新直营门店信息")
  @PatchMapping("")
  public Result<DirectStoreEntity> update(@RequestBody DirectStoreDto dto) {
    try {
      return Result.ok(this.directStoreService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除直营门店
   *
   * @param ids 直营门店id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.directStoreService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量拉取 MDG 直营门店数据
   *
   * @param dto 请求参数
   * @return 直营门店列表
   */
  @ApiOperation(value = "批量拉取 MDG 直营门店数据")
  @PostMapping(value = {"/pullKmsDirectStoreList"})
  public Result<?> pullKmsDirectStoreList(@RequestBody MasterDataMdgBaseDto dto) {
    try {
      this.directStoreService.pullKmsDirectStoreList(dto);
      return Result.ok("批量拉取 MDG 直营门店数据成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过系统查询售达方接口
   *
   * @param dto 请求参数
   * @return 直营门店列表
   */
  @ApiOperation(value = "通过系统查询售达方接口")
  @PostMapping(value = {"/findSoldToPartyByDirectCode"})
  public Result<List<DirectStoreEntity>> findSoldToPartyByDirectCode(@ApiParam(value = "直营门店Dto",name = "dto") @RequestBody DirectStoreDto dto) {
    try {
      List<DirectStoreEntity> DirectStoreEntity = this.directStoreService.findSoldToPartyByDirectCode(dto);
      return Result.ok(DirectStoreEntity);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
