package com.biz.crm.kms.business.direct.store.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.direct.store.local.service.DirectStoreService;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 直营门店: DirectStoreVo: 直营门店配置
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Slf4j
@RestController
@RequestMapping("/v1/directStore/directStore")
@Api(tags = "直营门店: DirectStoreVo: 直营门店配置")
public class DirectStoreVoController {

  @Autowired
  private DirectStoreVoService directStoreVoService;

  @Autowired
  private DirectStoreService directStoreService;

  /**
   * 通过ID获取直营门店详细信息
   *
   * @param id 直营门店ID
   * @return 直营门店信息
   */
  @ApiOperation(value = "通过ID获取直营门店详细信息")
  @GetMapping("/findById")
  public Result<DirectStoreVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<DirectStoreVo> list = this.directStoreVoService.findByIds(Sets.newHashSet(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 通过商超门店条件获取直营门店信息
   *
   * @param dto 参数dto
   * @return 直营门店信息
   */
  @ApiOperation("通过商超门店条件获取直营门店信息")
  @PostMapping("/findByDirectStoreConditionDto")
  public Result<List<DirectStoreVo>> findByDirectStoreConditionDto(@RequestBody DirectStoreConditionDto dto) {
    try {
      List<DirectStoreVo> list = this.directStoreVoService.findByDirectStoreConditionDto(dto);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 直营门店分页查询接口
   *
   * @param dto 参数dto
   * @return 直营门店信息
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("/findDirectStoreVoPage")
  public Result<Page<DirectStoreVo>> findDirectStoreVoPage(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "dimensionBudget", value = "商超门店条件dto") DirectStoreConditionDto dto) {
    try {
      Page<DirectStoreVo> page = this.directStoreService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
