package com.biz.crm.kms.business.direct.store.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 直营门店类
 *
 * @author ning.zhang
 * @date 2022/9/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DirectStoreEntity", description = "直营门店类")
@Entity
@TableName("kms_direct_store")
@Table(name = "kms_direct_store", indexes = {
    @Index(name = "kms_direct_store_index1", columnList = "tenant_code"),
    @Index(name = "kms_direct_store_index2", columnList = "direct_code"),
    @Index(name = "kms_direct_store_index3", columnList = "terminal_code"),
    @Index(name = "kms_direct_store_index4", columnList = "supermarket_store_code"),
})
@org.hibernate.annotations.Table(appliesTo = "kms_direct_store", comment = "直营门店表")
public class DirectStoreEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 8067295543099765881L;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  @Column(name = "terminal_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '送达方编码'")
  private String terminalCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  @Column(name = "terminal_name", length = 512, columnDefinition = "VARCHAR(512) COMMENT '送达方名称'")
  private String terminalName;

  @ApiModelProperty("售达方名称")
  @Column(name = "sold_to_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '售达方名称'")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  @Column(name = "sold_to_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '售达方编码'")
  private String soldToPartyCode;

  /**
   * 商超门店编码
   */
  @ApiModelProperty("商超门店编码")
  @Column(name = "supermarket_store_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超门店编码'")
  private String supermarketStoreCode;

  /**
   * 对账时间阈值
   */
  @ApiModelProperty("对账时间阈值")
  @Column(name = "time_threshold", length = 10, columnDefinition = "INT(10) COMMENT '对账时间阈值'")
  private Integer timeThreshold;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  @Column(name = "source_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
  private String sourceType;

  /**
   * 零售商区域
   */
  @ApiModelProperty(name = "零售商区域")
  @Column(name = "retailer_region", length = 32, columnDefinition = "varchar(32) COMMENT '零售商区域'")
  private String retailerRegion;

  /**
   * 业务区域
   */
  @ApiModelProperty("业务区域")
  @Column(name = "business_area", length = 64, columnDefinition = "varchar(64) COMMENT '业务区域'")
  private String businessArea;

  /**
   * 省编码(门店管理-省)
   */
  @ApiModelProperty("省编码(门店管理-省)")
  @Column(name = "province_code", length = 32, columnDefinition = "varchar(32) COMMENT '省编码(门店管理-省)'")
  private String provinceCode;

  /**
   * 省名称(门店管理-省)
   */
  @ApiModelProperty("省名称(门店管理-省)")
  @Column(name = "province_name", length = 32, columnDefinition = "varchar(32) COMMENT '省名称(门店管理-省)'")
  private String provinceName;

  /**
   * 关联已有送达方编码
   */
  @ApiModelProperty("关联已有送达方编码")
  @Column(name = "retailer_terminalCode", length = 32, columnDefinition = "varchar(32) COMMENT '关联已有送达方编码'")
  private String retailerTerminalCode;
}
