package com.biz.crm.kms.business.direct.store.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreDto;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.grab.rule.local.model.DirectStoreConditionModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 直营门店表的mybatis-plus接口类 {@link DirectStoreEntity}
 *
 * @author ning.zhang
 * @date 2022-09-28 10:28:04
 */
public interface DirectStoreMapper extends BaseMapper<DirectStoreEntity> {

  /**
   * 多条件查询直营门店列表
   *
   * @param model 条件model
   * @return 直营门店列表
   */
  List<DirectStoreEntity> findByDirectStoreConditionModel(@Param("model") DirectStoreConditionModel model);

    Page<DirectStoreVo> findByConditions(Page<DirectStoreVo> page, @Param("model") DirectStoreConditionDto dto);

  /**
   * 根据系统查询售达方
   * @param dto
   * @param tenantCode
   * @return
   */
  List<DirectStoreEntity> findSoldToPartyByDirectCode(@Param("dto") DirectStoreDto dto, @Param("tenantCode") String tenantCode);

  /**
   * 通过系统编码查询售达方
   * @param directCodes
   * @param tenantCode
   * @return
   */
  List<DirectStoreVo> findSoldToPartyByDirectCodes(@Param("directCodes") List<String> directCodes,@Param("tenantCode") String tenantCode);
}

