package com.biz.crm.kms.business.direct.store.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreDto;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 直营门店表服务接口
 *
 * @author ning.zhang
 * @date 2022-09-28 10:28:05
 */
public interface DirectStoreService {

  /**
   * 创建直营门店
   *
   * @param dto 请求参数dto
   * @return 直营门店实体
   */
  DirectStoreEntity create(DirectStoreDto dto);

  /**
   * 更新直营门店
   *
   * @param dto 请求参数dto
   * @return 直营门店实体
   */
  DirectStoreEntity update(DirectStoreDto dto);

  /**
   * 批量删除直营门店
   *
   * @param ids 直营门店id集合
   */
  void deleteBatch(List<String> ids);

    /**
     * 直营门店分页查询接口
     * */
    Page<DirectStoreVo> findByConditions(Pageable pageable, DirectStoreConditionDto dto);

    /**
     * 批量拉取 MDG 直营门店数据
     */
    void pullKmsDirectStoreList(MasterDataMdgBaseDto dto);

  /**
   * 通过系统查询售达方接口
   * @param dto
   * @return
   */
  List<DirectStoreEntity> findSoldToPartyByDirectCode(DirectStoreDto dto);

}
