package com.biz.crm.kms.business.direct.store.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.local.repository.DirectStoreRepository;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.grab.rule.local.model.DirectStoreConditionModel;
import com.biz.crm.kms.business.supermarket.store.sdk.service.SupermarketStoreVoService;
import com.biz.crm.kms.business.supermarket.store.sdk.vo.SupermarketStoreVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 直营门店Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/9/28
 */
@Service
@Slf4j
public class DirectStoreVoServiceImpl implements DirectStoreVoService {

  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private DirectStoreRepository directStoreRepository;
  @Autowired
  private SupermarketStoreVoService supermarketStoreVoService;
  @Autowired
  private DirectVoService directVoService;

  @Override
  public List<DirectStoreVo> findByIds(Set<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newLinkedList();
    }
    DirectStoreConditionModel model = new DirectStoreConditionModel();
    model.setIds(ids);
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<DirectStoreEntity> entities = this.directStoreRepository.findByDirectStoreConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<DirectStoreVo> list = (List<DirectStoreVo>) this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectStoreEntity.class
        , DirectStoreVo.class, HashSet.class, ArrayList.class);
    this.buildExtendInfo(list);
    return list;
  }

  @Override
  public List<DirectStoreVo> findByDirectStoreConditionDto(DirectStoreConditionDto dto) {
    dto = ObjectUtils.defaultIfNull(dto, new DirectStoreConditionDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    DirectStoreConditionModel model = this.nebulaToolkitService.copyObjectByWhiteList(dto, DirectStoreConditionModel.class, HashSet.class, ArrayList.class);
    model.setDirectCodes(dto.getDirectCodes());
    model.setTerminalCodes(dto.getTerminalCodes());
    model.setSupermarketStoreCodes(dto.getSupermarketStoreCodes());
    model.setSoldToPartyCodes(dto.getSoldToPartyCodes());
    List<DirectStoreEntity> entities = this.directStoreRepository.findByDirectStoreConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<DirectStoreVo> list = (List<DirectStoreVo>) this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectStoreEntity.class
        , DirectStoreVo.class, HashSet.class, ArrayList.class);
    this.buildExtendInfo(list);
    return list;
  }

  /**
   * 通过送达方查找售达方
   *
   * @param deliveryCodes
   * @return
   */
  @Override
  public List<DirectStoreVo> findByDeliveryCodes(List<String> deliveryCodes) {
    List<DirectStoreEntity> entities = this.directStoreRepository.findByDeliveryCodes(deliveryCodes,TenantUtils.getTenantCode());
    List<DirectStoreVo> voList = (List<DirectStoreVo>) this.nebulaToolkitService.copyCollectionByWhiteList(entities,DirectStoreEntity.class,DirectStoreVo.class,HashSet.class,ArrayList.class);
    this.buildExtendInfo(voList);
    return voList;
  }

  @Override
  public List<DirectStoreVo> findSoldPartyCodeByDirectCodes(List<String> directCodes) {
    return this.directStoreRepository.findSoldToPartyByDirectCodes(directCodes);
  }

  /**
   * 封装扩展信息
   *
   * @param list 直营门店列表
   */
  public void buildExtendInfo(List<DirectStoreVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> directCodes = Sets.newHashSet();
    Set<String> supermarketStoreCodes = Sets.newHashSet();
    list.forEach(directStoreVo -> {
      directCodes.add(directStoreVo.getDirectCode());
      supermarketStoreCodes.add(directStoreVo.getSupermarketStoreCode());
    });
    List<SupermarketStoreVo> storeList = this.supermarketStoreVoService.findByStoreCodes(supermarketStoreCodes);
    Map<String, SupermarketStoreVo> storeMap = CollectionUtils.isEmpty(storeList) ? Maps.newHashMap()
        : storeList.stream().collect(Collectors.toMap(SupermarketStoreVo::getStoreCode, t -> t, (a, b) -> a));
    List<DirectVo> directList = this.directVoService.findByDirectCodes(Lists.newArrayList(directCodes));
    Map<String, DirectVo> directMap = CollectionUtils.isEmpty(directList) ? Maps.newHashMap()
        : directList.stream().collect(Collectors.toMap(DirectVo::getDirectCode, t -> t, (a, b) -> a));
    list.forEach(directStoreVo -> {
      DirectVo directVo = directMap.getOrDefault(directStoreVo.getDirectCode(), new DirectVo());
      SupermarketStoreVo supermarketStoreVo = storeMap.getOrDefault(directStoreVo.getSupermarketStoreCode(), new SupermarketStoreVo());
      directStoreVo.setDirectName(directVo.getSupermarketName());
      directStoreVo.setSupermarketCode(supermarketStoreVo.getSupermarketCode());
      directStoreVo.setSupermarketName(supermarketStoreVo.getSupermarketName());
      directStoreVo.setSupermarketStoreName(supermarketStoreVo.getStoreName());
      directStoreVo.setSupermarketAreaCode(supermarketStoreVo.getSupermarketAreaCode());
      directStoreVo.setSupermarketAreaName(supermarketStoreVo.getSupermarketAreaName());
      directStoreVo.setCustomerOrgCode(directVo.getCustomerOrgCode());
      directStoreVo.setCustomerOrgName(directVo.getCustomerOrgName());
    });
  }
}
