/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.direct.store.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.local.service.DirectStoreService;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/directStore/directStore"})
@Api(tags={"\u76f4\u8425\u95e8\u5e97: DirectStore: \u76f4\u8425\u95e8\u5e97\u914d\u7f6e"})
public class DirectStoreController {
    private static final Logger log = LoggerFactory.getLogger(DirectStoreController.class);
    @Autowired
    private DirectStoreService directStoreService;

    @ApiOperation(value="\u65b0\u589e\u76f4\u8425\u95e8\u5e97")
    @PostMapping(value={""})
    public Result<DirectStoreEntity> create(@RequestBody DirectStoreDto dto) {
        try {
            return Result.ok((Object)((Object)this.directStoreService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u76f4\u8425\u95e8\u5e97\u4fe1\u606f")
    @PatchMapping(value={""})
    public Result<DirectStoreEntity> update(@RequestBody DirectStoreDto dto) {
        try {
            return Result.ok((Object)((Object)this.directStoreService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.directStoreService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6 MDG \u76f4\u8425\u95e8\u5e97\u6570\u636e")
    @PostMapping(value={"/pullKmsDirectStoreList"})
    public Result<?> pullKmsDirectStoreList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.directStoreService.pullKmsDirectStoreList(dto);
            return Result.ok((String)"\u6279\u91cf\u62c9\u53d6 MDG \u76f4\u8425\u95e8\u5e97\u6570\u636e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7cfb\u7edf\u67e5\u8be2\u552e\u8fbe\u65b9\u63a5\u53e3")
    @PostMapping(value={"/findSoldToPartyByDirectCode"})
    public Result<List<DirectStoreEntity>> findSoldToPartyByDirectCode(@ApiParam(value="\u76f4\u8425\u95e8\u5e97Dto", name="dto") @RequestBody DirectStoreDto dto) {
        try {
            List<DirectStoreEntity> DirectStoreEntity2 = this.directStoreService.findSoldToPartyByDirectCode(dto);
            return Result.ok(DirectStoreEntity2);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

