/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.direct.store.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.direct.store.local.service.DirectStoreService;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/directStore/directStore"})
@Api(tags={"\u76f4\u8425\u95e8\u5e97: DirectStoreVo: \u76f4\u8425\u95e8\u5e97\u914d\u7f6e"})
public class DirectStoreVoController {
    private static final Logger log = LoggerFactory.getLogger(DirectStoreVoController.class);
    @Autowired
    private DirectStoreVoService directStoreVoService;
    @Autowired
    private DirectStoreService directStoreService;

    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u76f4\u8425\u95e8\u5e97\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<DirectStoreVo> findById(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            List list = this.directStoreVoService.findByIds((Set)Sets.newHashSet((Object[])new String[]{id}));
            return Result.ok(CollectionUtils.isEmpty((Collection)list) ? null : (DirectStoreVo)list.get(0));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u5546\u8d85\u95e8\u5e97\u6761\u4ef6\u83b7\u53d6\u76f4\u8425\u95e8\u5e97\u4fe1\u606f")
    @PostMapping(value={"/findByDirectStoreConditionDto"})
    public Result<List<DirectStoreVo>> findByDirectStoreConditionDto(@RequestBody DirectStoreConditionDto dto) {
        try {
            List list = this.directStoreVoService.findByDirectStoreConditionDto(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findDirectStoreVoPage"})
    public Result<Page<DirectStoreVo>> findDirectStoreVoPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dimensionBudget", value="\u5546\u8d85\u95e8\u5e97\u6761\u4ef6dto") DirectStoreConditionDto dto) {
        try {
            Page<DirectStoreVo> page = this.directStoreService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

