/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.direct.store.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.local.mapper.DirectStoreMapper;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreDto;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.grab.rule.local.model.DirectStoreConditionModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class DirectStoreRepository
extends ServiceImpl<DirectStoreMapper, DirectStoreEntity> {
    public List<DirectStoreEntity> findByDirectStoreConditionModel(DirectStoreConditionModel model) {
        if (StringUtils.isBlank((CharSequence)model.getTenantCode())) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(model.getIds()) && CollectionUtils.isEmpty(model.getDirectCodes()) && CollectionUtils.isEmpty(model.getSupermarketStoreCodes()) && CollectionUtils.isEmpty(model.getTerminalCodes()) && CollectionUtils.isEmpty(model.getSoldToPartyCodes()) && StringUtils.isBlank((CharSequence)model.getDirectCode()) && StringUtils.isBlank((CharSequence)model.getTerminalCode()) && StringUtils.isBlank((CharSequence)model.getSupermarketStoreCode())) {
            return Collections.emptyList();
        }
        return ((DirectStoreMapper)this.baseMapper).findByDirectStoreConditionModel(model);
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Page<DirectStoreVo> findByConditions(Pageable pageable, DirectStoreConditionDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((DirectStoreMapper)this.baseMapper).findByConditions((Page<DirectStoreVo>)page, dto);
    }

    public List<DirectStoreEntity> findByDeliveryCodes(List<String> deliveryCodes, String tenantCode) {
        if (CollectionUtils.isEmpty(deliveryCodes)) {
            return new ArrayList<DirectStoreEntity>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(DirectStoreEntity::getTerminalCode, deliveryCodes)).list();
    }

    public List<DirectStoreEntity> findSoldToPartyByDirectCode(DirectStoreDto dto) {
        if (ObjectUtils.isEmpty((Object)dto) || StringUtils.isEmpty((CharSequence)dto.getDirectCode())) {
            return new ArrayList<DirectStoreEntity>();
        }
        return ((DirectStoreMapper)this.baseMapper).findSoldToPartyByDirectCode(dto, TenantUtils.getTenantCode());
    }

    public List<DirectStoreVo> findSoldToPartyByDirectCodes(List<String> directCodes) {
        if (CollectionUtils.isEmpty(directCodes)) {
            return Lists.newArrayList();
        }
        return ((DirectStoreMapper)this.baseMapper).findSoldToPartyByDirectCodes(directCodes, TenantUtils.getTenantCode());
    }
}

