/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.direct.store.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.local.repository.DirectStoreRepository;
import com.biz.crm.kms.business.direct.store.local.service.DirectStoreService;
import com.biz.crm.kms.business.direct.store.local.service.internal.DirectStoreVoServiceImpl;
import com.biz.crm.kms.business.direct.store.sdk.constant.StoreConstant;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreDto;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.grab.rule.local.model.DirectStoreConditionModel;
import com.biz.crm.kms.business.supermarket.sdk.service.SupermarketVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgKmsDirectStoreVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="directStoreService")
public class DirectStoreServiceImpl
implements DirectStoreService {
    private static final Logger log = LoggerFactory.getLogger(DirectStoreServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DirectStoreRepository directStoreRepository;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private DirectVoService directVoService;
    @Autowired(required=false)
    private SupermarketVoService supermarketVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DirectStoreVoServiceImpl directStoreVoServiceImpl;

    @Override
    @Transactional
    public DirectStoreEntity create(DirectStoreDto dto) {
        this.createValidation(dto);
        DirectStoreEntity entity = (DirectStoreEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, DirectStoreEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.directStoreRepository.save((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public DirectStoreEntity update(DirectStoreDto dto) {
        this.updateValidation(dto);
        DirectStoreConditionModel model = new DirectStoreConditionModel();
        model.setIds(Sets.newHashSet((Object[])new String[]{dto.getId()}));
        model.setTenantCode(dto.getTenantCode());
        List<DirectStoreEntity> entities = this.directStoreRepository.findByDirectStoreConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u76f4\u8425\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        DirectStoreEntity updateEntity = (DirectStoreEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, DirectStoreEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.directStoreRepository.updateById((Object)updateEntity);
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.directStoreRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.directStoreRepository.updateDelFlagByIds(ids);
    }

    @Override
    public Page<DirectStoreVo> findByConditions(Pageable pageable, DirectStoreConditionDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        if (dto == null) {
            dto = new DirectStoreConditionDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        Page<DirectStoreVo> byConditions = this.directStoreRepository.findByConditions(pageable, dto);
        List directStoreVos = byConditions.getRecords();
        this.directStoreVoServiceImpl.buildExtendInfo(directStoreVos);
        byConditions.setRecords(directStoreVos);
        return byConditions;
    }

    @DynamicTaskService(cornExpression="0 30 22 * * ?", taskDesc="\u81ea\u52a8\u62c9\u53d6MDG\u76f4\u8425\u95e8\u5e97\u6570\u636e")
    public void authPullKmsDirectStoreList() {
        MasterDataMdgBaseDto dto = new MasterDataMdgBaseDto();
        this.pullKmsDirectStoreList(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullKmsDirectStoreList(MasterDataMdgBaseDto dto) {
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum(StoreConstant.STORE_PAGE_NUM.toString());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize(StoreConstant.STORE_PAGE_SIZE.toString());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getDs())) {
            String date = DateUtil.getDate((String)"yyyyMMdd");
            Integer i = Integer.parseInt(date) - 1;
            dto.setDs(i.toString());
        }
        boolean lock = this.redisMutexService.tryLock("KMS:STORE:PULL:LOCK", TimeUnit.SECONDS, StoreConstant.STORE_REDIS_TIME.intValue());
        try {
            List allDirect = this.directVoService.findAllDirect();
            HashMap directMap = Maps.newHashMap();
            List<DirectVo> directVos = Lists.newArrayList();
            for (DirectVo directVo : allDirect) {
                if (!"DY00000010".equals(directVo.getBusinessUnitCode()) || !StringUtils.isNotEmpty((CharSequence)directVo.getCustomerRetailerName())) continue;
                if (CollectionUtils.isEmpty((Collection)((Collection)directMap.get(directVo.getCustomerRetailerName())))) {
                    directVos = Lists.newArrayList();
                    directVos.add(directVo);
                    directMap.put(directVo.getCustomerRetailerName(), directVos);
                    continue;
                }
                directVos = (List)directMap.get(directVo.getCustomerRetailerName());
                directVos.add(directVo);
                directMap.put(directVo.getCustomerRetailerName(), directVos);
            }
            this.pullKmsDirectStore(dto, directMap);
        }
        catch (Exception e) {
            log.error("\u62c9\u53d6\u76f4\u8425\u95e8\u5e97\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (lock) {
                this.redisMutexService.unlock("KMS:STORE:PULL:LOCK");
            }
        }
    }

    @Override
    public List<DirectStoreEntity> findSoldToPartyByDirectCode(DirectStoreDto dto) {
        return this.directStoreRepository.findSoldToPartyByDirectCode(dto);
    }

    private void pullKmsDirectStore(MasterDataMdgBaseDto dto, Map<String, List<DirectVo>> directMap) {
        List directStoreVos = this.masterDataMdgService.pullKmsDirectStoreList(dto);
        if (!CollectionUtils.isEmpty((Collection)directStoreVos)) {
            Integer currentCount = directStoreVos.size();
            ArrayList storeList = Lists.newArrayList();
            HashSet storeCodes = Sets.newHashSet();
            ArrayList oldStoreVos = Lists.newArrayList();
            MasterDataMdgKmsDirectStoreVo oldStoreVo = new MasterDataMdgKmsDirectStoreVo();
            for (MasterDataMdgKmsDirectStoreVo directStoreVo : directStoreVos) {
                if (StringUtils.isNotEmpty((CharSequence)directStoreVo.getOldRetailerStoreCode()) && !StringUtils.equals((CharSequence)directStoreVo.getRetailerStoreCode(), (CharSequence)directStoreVo.getOldRetailerStoreCode())) {
                    storeCodes.add(directStoreVo.getOldRetailerStoreCode());
                    oldStoreVo = new MasterDataMdgKmsDirectStoreVo();
                    oldStoreVo.setRetailerName(directStoreVo.getRetailerName());
                    oldStoreVo.setRetailerRegion(directStoreVo.getRetailerRegion());
                    oldStoreVo.setStoreCode(directStoreVo.getStoreCode());
                    oldStoreVo.setStoreName(directStoreVo.getStoreName());
                    oldStoreVo.setRetailerStoreCode(directStoreVo.getOldRetailerStoreCode());
                    oldStoreVos.add(oldStoreVo);
                }
                storeCodes.add(directStoreVo.getStoreCode());
            }
            if (!CollectionUtils.isEmpty((Collection)oldStoreVos)) {
                directStoreVos.addAll(oldStoreVos);
            }
            ArrayList storeCodeList = Lists.newArrayList((Iterable)storeCodes);
            List terminalVos = this.terminalVoService.findMainDetailsByTerminalCodesUsePost((List)storeCodeList);
            HashMap terminalVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)terminalVos)) {
                for (TerminalVo terminalVo : terminalVos) {
                    terminalVoMap.put(terminalVo.getTerminalCode(), terminalVo);
                }
            }
            DirectStoreConditionModel model = new DirectStoreConditionModel();
            model.setTerminalCodes(storeCodes);
            model.setTenantCode(TenantUtils.getTenantCode());
            List<DirectStoreEntity> directStoreEntityList = this.directStoreRepository.findByDirectStoreConditionModel(model);
            HashMap directStoreMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(directStoreEntityList)) {
                for (DirectStoreEntity directStoreEntity : directStoreEntityList) {
                    directStoreMap.put(directStoreEntity.getDirectCode() + "-" + directStoreEntity.getTerminalCode() + "-" + directStoreEntity.getSupermarketStoreCode() + "-" + directStoreEntity.getRetailerRegion(), directStoreEntity);
                }
            }
            HashMap map = Maps.newHashMap();
            DirectStoreEntity store = new DirectStoreEntity();
            for (MasterDataMdgKmsDirectStoreVo directStoreVo : directStoreVos) {
                if (CollectionUtils.isEmpty((Collection)directMap.get(directStoreVo.getRetailerName()))) continue;
                List<DirectVo> directVoList = directMap.get(directStoreVo.getRetailerName());
                for (DirectVo directVo : directVoList) {
                    store = new DirectStoreEntity();
                    if (map.get(directVo.getDirectCode() + "-" + directStoreVo.getStoreCode() + "-" + directStoreVo.getRetailerStoreCode() + "-" + directStoreVo.getRetailerRegion()) != null) continue;
                    map.put(directVo.getDirectCode() + "-" + directStoreVo.getStoreCode() + "-" + directStoreVo.getRetailerStoreCode() + "-" + directStoreVo.getRetailerRegion(), "1");
                    if (terminalVoMap.get(directStoreVo.getStoreCode()) == null) continue;
                    store.setSoldToPartyCode(((TerminalVo)terminalVoMap.get(directStoreVo.getStoreCode())).getSellerCode());
                    store.setSoldToPartyName(((TerminalVo)terminalVoMap.get(directStoreVo.getStoreCode())).getSellerName());
                    store.setProvinceCode(((TerminalVo)terminalVoMap.get(directStoreVo.getStoreCode())).getProvinceCode());
                    store.setProvinceName(((TerminalVo)terminalVoMap.get(directStoreVo.getStoreCode())).getProvinceName());
                    store.setBusinessArea(((TerminalVo)terminalVoMap.get(directStoreVo.getStoreCode())).getRegionCode());
                    store.setDirectCode(directVo.getDirectCode());
                    DirectStoreEntity oldStore = (DirectStoreEntity)((Object)directStoreMap.get(store.getDirectCode() + "-" + directStoreVo.getStoreCode() + "-" + directStoreVo.getRetailerStoreCode() + "-" + directStoreVo.getRetailerRegion()));
                    if (oldStore != null) {
                        store.setId(oldStore.getId());
                    }
                    store.setSupermarketStoreCode(directStoreVo.getRetailerStoreCode());
                    store.setTerminalCode(directStoreVo.getStoreCode());
                    store.setTerminalName(directStoreVo.getStoreName());
                    store.setTenantCode(TenantUtils.getTenantCode());
                    if (StringUtils.isNotEmpty((CharSequence)directStoreVo.getRetailerRegion())) {
                        store.setRetailerRegion(directStoreVo.getRetailerRegion());
                    }
                    storeList.add(store);
                }
            }
            this.directStoreRepository.saveOrUpdateBatch(storeList);
            if (currentCount == 1000) {
                Integer pageNum = Integer.parseInt(dto.getPageNum());
                pageNum = pageNum + 1;
                dto.setPageNum(pageNum.toString());
                this.pullKmsDirectStore(dto, directMap);
            } else {
                return;
            }
        }
    }

    private void createValidation(DirectStoreDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getDirectCode(), (String)"\u7f3a\u5931\u7cfb\u7edf\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSupermarketStoreCode(), (String)"\u7f3a\u5931\u5546\u8d85\u95e8\u5e97\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTerminalCode(), (String)"\u7f3a\u5931\u9001\u8fbe\u65b9\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTerminalName(), (String)"\u7f3a\u5931\u9001\u8fbe\u65b9\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(dto.getTimeThreshold()), (String)"\u7f3a\u5931\u5bf9\u8d26\u65f6\u95f4\u9608\u503c", (Object[])new Object[0]);
        DirectStoreConditionModel model = new DirectStoreConditionModel();
        model.setTenantCode(dto.getTenantCode());
        model.setDirectCode(dto.getDirectCode());
        model.setSupermarketStoreCode(dto.getSupermarketStoreCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<DirectStoreEntity> entities = this.directStoreRepository.findByDirectStoreConditionModel(model);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(entities), (String)"\u5ba2\u6237\u95e8\u5e97\u5df2\u5b58\u5728\u5173\u8054\u4f01\u4e1a\u95e8\u5e97", (Object[])new Object[0]);
    }

    private void updateValidation(DirectStoreDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDirectCode(), (String)"\u7f3a\u5931\u7cfb\u7edf\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSupermarketStoreCode(), (String)"\u7f3a\u5931\u5546\u8d85\u95e8\u5e97\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTerminalCode(), (String)"\u7f3a\u5931\u9001\u8fbe\u65b9\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTerminalName(), (String)"\u7f3a\u5931\u9001\u8fbe\u65b9\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(dto.getTimeThreshold()), (String)"\u7f3a\u5931\u5bf9\u8d26\u65f6\u95f4\u9608\u503c", (Object[])new Object[0]);
        DirectStoreConditionModel model = new DirectStoreConditionModel();
        model.setTenantCode(dto.getTenantCode());
        model.setDirectCode(dto.getDirectCode());
        model.setSupermarketStoreCode(dto.getSupermarketStoreCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<DirectStoreEntity> entities = this.directStoreRepository.findByDirectStoreConditionModel(model);
        if (!CollectionUtils.isEmpty(entities)) {
            entities = entities.stream().filter(directStoreEntity -> !dto.getId().equals(directStoreEntity.getId())).collect(Collectors.toList());
        }
        Validate.isTrue((boolean)CollectionUtils.isEmpty(entities), (String)"\u5ba2\u6237\u95e8\u5e97\u5df2\u5b58\u5728\u5173\u8054\u4f01\u4e1a\u95e8\u5e97", (Object[])new Object[0]);
    }
}

