/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.direct.store.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.local.entity.DirectStoreEntity;
import com.biz.crm.kms.business.direct.store.local.repository.DirectStoreRepository;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.grab.rule.local.model.DirectStoreConditionModel;
import com.biz.crm.kms.business.supermarket.store.sdk.service.SupermarketStoreVoService;
import com.biz.crm.kms.business.supermarket.store.sdk.vo.SupermarketStoreVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DirectStoreVoServiceImpl
implements DirectStoreVoService {
    private static final Logger log = LoggerFactory.getLogger(DirectStoreVoServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DirectStoreRepository directStoreRepository;
    @Autowired
    private SupermarketStoreVoService supermarketStoreVoService;
    @Autowired
    private DirectVoService directVoService;

    public List<DirectStoreVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        DirectStoreConditionModel model = new DirectStoreConditionModel();
        model.setIds(ids);
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<DirectStoreEntity> entities = this.directStoreRepository.findByDirectStoreConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectStoreEntity.class, DirectStoreVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildExtendInfo(list);
        return list;
    }

    public List<DirectStoreVo> findByDirectStoreConditionDto(DirectStoreConditionDto dto) {
        dto = (DirectStoreConditionDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new DirectStoreConditionDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        DirectStoreConditionModel model = (DirectStoreConditionModel)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DirectStoreConditionModel.class, HashSet.class, ArrayList.class, new String[0]);
        model.setDirectCodes(dto.getDirectCodes());
        model.setTerminalCodes(dto.getTerminalCodes());
        model.setSupermarketStoreCodes(dto.getSupermarketStoreCodes());
        model.setSoldToPartyCodes(dto.getSoldToPartyCodes());
        List<DirectStoreEntity> entities = this.directStoreRepository.findByDirectStoreConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectStoreEntity.class, DirectStoreVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildExtendInfo(list);
        return list;
    }

    public List<DirectStoreVo> findByDeliveryCodes(List<String> deliveryCodes) {
        List<DirectStoreEntity> entities = this.directStoreRepository.findByDeliveryCodes(deliveryCodes, TenantUtils.getTenantCode());
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectStoreEntity.class, DirectStoreVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildExtendInfo(voList);
        return voList;
    }

    public List<DirectStoreVo> findSoldPartyCodeByDirectCodes(List<String> directCodes) {
        return this.directStoreRepository.findSoldToPartyByDirectCodes(directCodes);
    }

    public void buildExtendInfo(List<DirectStoreVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet directCodes = Sets.newHashSet();
        HashSet supermarketStoreCodes = Sets.newHashSet();
        list.forEach(directStoreVo -> {
            directCodes.add(directStoreVo.getDirectCode());
            supermarketStoreCodes.add(directStoreVo.getSupermarketStoreCode());
        });
        List storeList = this.supermarketStoreVoService.findByStoreCodes((Set)supermarketStoreCodes);
        HashMap storeMap = CollectionUtils.isEmpty((Collection)storeList) ? Maps.newHashMap() : storeList.stream().collect(Collectors.toMap(SupermarketStoreVo::getStoreCode, t -> t, (a, b) -> a));
        List directList = this.directVoService.findByDirectCodes((List)Lists.newArrayList((Iterable)directCodes));
        HashMap directMap = CollectionUtils.isEmpty((Collection)directList) ? Maps.newHashMap() : directList.stream().collect(Collectors.toMap(DirectVo::getDirectCode, t -> t, (a, b) -> a));
        list.forEach(directStoreVo -> {
            DirectVo directVo = directMap.getOrDefault(directStoreVo.getDirectCode(), new DirectVo());
            SupermarketStoreVo supermarketStoreVo = storeMap.getOrDefault(directStoreVo.getSupermarketStoreCode(), new SupermarketStoreVo());
            directStoreVo.setDirectName(directVo.getSupermarketName());
            directStoreVo.setSupermarketCode(supermarketStoreVo.getSupermarketCode());
            directStoreVo.setSupermarketName(supermarketStoreVo.getSupermarketName());
            directStoreVo.setSupermarketStoreName(supermarketStoreVo.getStoreName());
            directStoreVo.setSupermarketAreaCode(supermarketStoreVo.getSupermarketAreaCode());
            directStoreVo.setSupermarketAreaName(supermarketStoreVo.getSupermarketAreaName());
            directStoreVo.setCustomerOrgCode(directVo.getCustomerOrgCode());
            directStoreVo.setCustomerOrgName(directVo.getCustomerOrgName());
        });
    }
}

