package com.biz.crm.kms.business.direct.store.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 门店数据常量类
 *
 * @author cyj
 * @date 2022/11/29
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class StoreConstant {

  /**
   * redis锁定时间
   * */
  public static final Integer STORE_REDIS_TIME = 1800;

  /**
   * 分页默认开始页数
   * */
  public static final Integer STORE_PAGE_NUM = 1;

  /**
   * 分页size
   */
  public static final Integer STORE_PAGE_SIZE = 1000;

  /**
   * 门店redis锁前缀
   * */
  public static final String STORE_PULL_LOCK = "KMS:STORE:PULL:LOCK";
}
