package com.biz.crm.kms.business.direct.store.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 商超门店条件dto
 *
 * @author ning.zhang
 * @date 2022/10/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "DirectStoreConditionDto", description = "商超门店条件dto")
public class DirectStoreConditionDto extends TenantDto {

  /**
   * 数据状态（删除状态）
   */
  @ApiModelProperty("数据状态（删除状态）")
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @ApiModelProperty("数据业务状态（启用状态）")
  private String enableStatus;

  /**
   * 编码或名称
   */
  @ApiModelProperty("编码或名称")
  private String codeUnionName;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String terminalCode;

  /**
   * 系统编码集合
   */
  @ApiModelProperty("系统编码集合")
  private Set<String> directCodes;

  /**
   * 商超门店编码集合
   */
  @ApiModelProperty("商超门店编码集合")
  private Set<String> supermarketStoreCodes;

  /**
   * 送达方编码集合
   */
  @ApiModelProperty("送达方编码集合")
  private Set<String> terminalCodes;

  /**
   * 售达方编码集合
   */
  @ApiModelProperty("售达方编码集合")
  private Set<String> soldToPartyCodes;
}
