package com.biz.crm.kms.business.direct.store.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 直营门店dto
 *
 * @author ning.zhang
 * @date 2022/9/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "DirectStoreDto", description = "直营门店dto")
public class DirectStoreDto extends TenantDto {

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String terminalCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  private String terminalName;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

  /**
   * 商超门店编码
   */
  @ApiModelProperty("商超门店编码")
  private String supermarketStoreCode;

  /**
   * 对账时间阈值
   */
  @ApiModelProperty("对账时间阈值")
  private Integer timeThreshold;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /**
   * 零售商区域
   */
  @ApiModelProperty(name = "零售商区域")
  private String retailerRegion;

  /**
   * 业务区域
   */
  @ApiModelProperty("业务区域")
  private String businessArea;

  /**
   * 省编码(门店管理-省)
   */
  @ApiModelProperty("省编码(门店管理-省)")
  private String provinceCode;

  /**
   * 省名称(门店管理-省)
   */
  @ApiModelProperty("省名称(门店管理-省)")
  private String provinceName;
}
