package com.biz.crm.kms.business.direct.store.sdk.service;

import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;

import java.util.List;
import java.util.Set;

/**
 * 直营门店Vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/9/28
 */
public interface DirectStoreVoService {

  /**
   * 通过直营门店ID集合获取直营门店信息
   *
   * @param ids 直营门店ID集合
   * @return 直营门店信息
   */
  List<DirectStoreVo> findByIds(Set<String> ids);

  /**
   * 通过商超门店条件获取直营门店信息
   *
   * @param dto 参数dto
   * @return 直营门店信息
   */
  List<DirectStoreVo> findByDirectStoreConditionDto(DirectStoreConditionDto dto);

  /**
   * 通过送达方编码查找售达方编码
   * @param deliveryCodes
   * @return
   */
  List<DirectStoreVo> findByDeliveryCodes(List<String> deliveryCodes);

  /**
   * 通过系统查询售达方
   * @param directCodes
   * @return
   */
  List<DirectStoreVo> findSoldPartyCodeByDirectCodes(List<String> directCodes);
}
