package com.biz.crm.kms.business.direct.store.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 直营门店vo
 *
 * @author ning.zhang
 * @date 2022/9/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "DirectStoreVo", description = "直营门店vo")
public class DirectStoreVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -3862275511649888858L;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 系统名称
   */
  @ApiModelProperty("系统名称")
  private String directName;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String terminalCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  private String terminalName;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

  /**
   * 商超门店编码
   */
  @ApiModelProperty("商超门店编码")
  private String supermarketStoreCode;

  /**
   * 商超门店名称
   */
  @ApiModelProperty("商超门店名称")
  private String supermarketStoreName;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;

  /**
   * 商超名称
   */
  @ApiModelProperty("商超名称")
  private String supermarketName;

  /**
   * 商超区域编码
   */
  @ApiModelProperty("商超区域编码")
  private String supermarketAreaCode;

  /**
   * 商超区域名称
   */
  @ApiModelProperty("商超区域名称")
  private String supermarketAreaName;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  private String customerOrgName;

  /**
   * 对账时间阈值
   */
  @ApiModelProperty("对账时间阈值")
  private Integer timeThreshold;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /**
   * 零售商区域
   */
  @ApiModelProperty(name = "零售商区域")
  private String retailerRegion;

  /**
   * 业务区域
   */
  @ApiModelProperty("业务区域")
  private String businessArea;

  /**
   * 省编码(门店管理-省)
   */
  @ApiModelProperty("省编码(门店管理-省)")
  private String provinceCode;

  /**
   * 省名称(门店管理-省)
   */
  @ApiModelProperty("省名称(门店管理-省)")
  private String provinceName;

  /**
   * 关联已有送达方编码
   */
  @ApiModelProperty("关联已有送达方编码")
  private String retailerTerminalCode;
}
