package com.biz.crm.kms.business.document.capture.log.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.local.service.DocumentCaptureLogService;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.GrabRequestSynchronizeDto;
import com.biz.crm.kms.business.document.capture.log.sdk.service.DocumentCaptureLogSynchronizeService;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.LogNumShowVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * (DocumentCaptureLog)表相关的http接口
 *
 * @author hd
 * @since 2023-01-10 11:05:25
 */
@RestController
@RequestMapping("/v1/documentCaptureLog/documentCaptureLog")
@Slf4j
@Api(tags = "KMS-单据抓取日志")
public class DocumentCaptureLogController {
    /**
     * 服务对象
     */
    @Autowired
    private DocumentCaptureLogService documentCaptureLogService;

    /**
     * 分页查询抓单日志数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询抓单日志数据")
    @GetMapping("findByConditions")
    public Result<LogNumShowVo> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                 @ApiParam(name = "dto", value = "查询条件") DocumentCaptureLogQueryDto dto) {
        try {
            LogNumShowVo page = documentCaptureLogService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过日志编号查询单条数据
     *
     * @param logCode 日志编号
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{logCode}")
    public Result<DocumentCaptureLogEntity> findByLogCode(@PathVariable @ApiParam(name = "id", value = "主键id") String logCode) {
        try {
            DocumentCaptureLogEntity logVo = this.documentCaptureLogService.findByLogCode(logCode);
            return Result.ok(logVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
