package com.biz.crm.kms.business.document.capture.log.local.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "accountReceivableEntity", description = "KMS-单据抓取日志实体")
@Entity
@TableName("kms_document_capture_log")
@Table(name = "kms_document_capture_log", indexes = {
        @Index(name = "kms_document_capture_log_index1", columnList = "uuid"),
        @Index(name = "kms_document_capture_log_index2", columnList = "create_time"),
        @Index(name = "kms_document_capture_log_index3", columnList = "item_type")
})
@org.hibernate.annotations.Table(appliesTo = "kms_document_capture_log", comment = "KMS-单据抓取日志数据表单")
public class DocumentCaptureLogEntity extends TenantFlagOpEntity {

    /**
     * 时间(yyyy-MM-dd HH:mm:ss)
     */
    @ApiModelProperty(name = "时间(yyyy-MM-dd HH:mm:ss)")
    @Column(name = "log_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '时间(yyyy-MM-dd HH:mm:ss)'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date LogDate;
    /**
     * 日志编号
     */
    @ApiModelProperty(name = "日志编号")
    @Column(name = "log_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '日志编号'")
    private String logCode;
    /**
     * 登录账号
     */
    @ApiModelProperty(name = "登录账号")
    @Column(name = "login_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '登录账号'")
    private String loginId;
    /**
     * 单据类型
     */
    @ApiModelProperty(name = "单据类型")
    @Column(name = "item_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据类型'")
    private String itemType;
    /**
     * 抓单规则
     */
    @ApiModelProperty(name = "抓单规则")
    @Column(name = "capture_rule", length = 256, columnDefinition = "VARCHAR(256) COMMENT '抓单规则'")
    private String captureRule;
    /**
     * 抓取方式
     */
    @ApiModelProperty(name = "抓取方式")
    @Column(name = "grab_mode", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓取方式'")
    private String grabMode;
    /**
     * 抓取状态
     */
    @ApiModelProperty(name = "抓取状态")
    @Column(name = "grab_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓取状态'")
    private String grabStatus;
    /**
     * 解析状态
     */
    @ApiModelProperty(name = "解析状态")
    @Column(name = "parse_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '解析状态'")
    private String parseStatus;
    /**
     * 转换状态
     */
    @ApiModelProperty(name = "转换状态")
    @Column(name = "transition_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '转换状态'")
    private String transitionStatus;
    /**
     * 处理结果
     */
    @ApiModelProperty(name = "处理结果")
    @Column(name = "handle_result", length = 256, columnDefinition = "VARCHAR(256) COMMENT '处理结果'")
    private String handleResult;
    /**
     * 账号备注
     */
    @ApiModelProperty(name = "账号备注")
    @Column(name = "account_remark", length = 128, columnDefinition = "varchar(128) COMMENT '账号备注'")
    private String accountRemark;
    /**
     * 直营体系
     */
    @ApiModelProperty("直营体系编码")
    @Column(name = "direct_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统编码'")
    private String directCode;
    /**
     * 直营体系名称
     */
    @ApiModelProperty("直营体系名称")
    @Column(name = "direct_name", length = 64, columnDefinition = "varchar(32) COMMENT '系统名称'")
    private String directName;
    /**
     * 相关单据抓取任务数量
     */
    @ApiModelProperty("相关单据抓取任务数量")
    @Column(name = "doc_relate_crawl_job_num", length = 20, columnDefinition = "int(20) COMMENT '相关单据抓取任务数量'")
    private Integer docRelateCrawlJobNum;
    /**
     * 异常登陆次数
     */
    @ApiModelProperty("异常登陆次数")
    @Column(name = "abnormal_login_num", length = 20, columnDefinition = "int(20) COMMENT '异常登陆次数'")
    private Integer abnormalLoginNum;
    /**
     * 抓单任务名称
     */
    @ApiModelProperty(name = "抓单任务名称")
    @Column(name = "grab_task_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓单任务名称'")
    private String grabTaskName;
    /**
     * 抓单时间
     */
    @ApiModelProperty(name = "抓单时间")
    @Column(name = "grab_time", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓单时间'")
    private String grabTime;
    /**
     * 抓单时间间隔
     */
    @ApiModelProperty(name = "抓单时间间隔")
    @Column(name = "grab_time_interval", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓单时间间隔'")
    private String grabTimeInterval;
    /**
     * 近三天异常次数
     */
    @ApiModelProperty(name = "近三天异常次数")
    @Column(name = "three_day_anomaly_num", length = 20, columnDefinition = "int(20) COMMENT '异常登陆次数'")
    private Integer threeDayAnomalyNum;
    /**
     * 商超系统登录结果
     */
    @ApiModelProperty(name = "登录结果")
    @Column(name = "supermarket_login_result", length = 32, columnDefinition = "VARCHAR(32) COMMENT '商超系统登录结果'")
    private String supermarketLoginResult;
    /**
     * 商超系统登录返回信息
     */
    @ApiModelProperty(name = "返回信息")
    @Column(name = "supermarket_login_return_msg", length = 256, columnDefinition = "VARCHAR(256) COMMENT '商超系统登录返回信息'")
    private String supermarketLoginReturnMsg;
    /**
     * 原始数量
     */
    @ApiModelProperty(name = "原始数量")
    @Column(name = "original_num", length = 20, columnDefinition = "int(20) COMMENT '原始数据量'")
    private Integer originalNum;
    /**
     * 抓取数量
     */
    @ApiModelProperty(name = "抓取数量")
    @Column(name = "grab_num", length = 20, columnDefinition = "int(20) COMMENT '抓取数据量'")
    private Integer grabNum;
    /**
     * 抓取成功
     */
    @ApiModelProperty(name = "抓取成功")
    @Column(name = "grab_succeed_num", length = 20, columnDefinition = "int(20) COMMENT '抓取成功数据量'")
    private Integer grabSucceedNum;
    /**
     * 抓取失败
     */
    @ApiModelProperty(name = "抓取失败")
    @Column(name = "grab_fail_num", length = 20, columnDefinition = "int(20) COMMENT '抓取失败数据量'")
    private Integer grabFailNum;
    /**
     * UUID(PYTHON需要字段)
     */
    @ApiModelProperty("UUID(PYTHON需要字段)")
    @Column(name = "uuid", columnDefinition = "VARCHAR(255) COMMENT 'UUID(PYTHON需要字段)'")
    private String uuid;
    /**
     * 操作用户
     */
    @ApiModelProperty(name = "操作用户")
    @Column(name = "nick_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '操作用户'")
    private String nickName;
    /**
     * 网址
     */
    @ApiModelProperty(name = "网址")
    @Column(name = "site_url", length = 64, columnDefinition = "VARCHAR(64) COMMENT '网址'")
    private String siteUrl;
}


