package com.biz.crm.kms.business.document.capture.log.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.document.capture.log.local.exports.dto.DocumentCaptureLogExportDto;
import com.biz.crm.kms.business.document.capture.log.local.exports.vo.DocumentCaptureLogExportVo;
import com.biz.crm.kms.business.document.capture.log.local.mapper.DocumentCaptureLogMapper;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.enums.OrderTypeEnum;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.DocumentCaptureLogVo;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.InvoiceMatchLogVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Class InvoiceAcceptanceExportProcess
 * @Description 验收单明细导出
 * @Author : ZS
 * @Date: 2023/1/7  17:16
 */
@Component
@Slf4j
public class DocumentCaptureLogExportProcess implements ExportProcess<DocumentCaptureLogExportVo> {

    @Autowired(required = false)
    private DocumentCaptureLogMapper documentCaptureLogMapper;

    //TODO 当前单据日志导出只导出验收单的
    @Override
    public Integer getTotal(Map<String, Object> params) {
        DocumentCaptureLogQueryDto dto = this.convertParams(params);
        Integer a = this.documentCaptureLogMapper.findAcceptanceCount(dto)+this.documentCaptureLogMapper.findAcceptance(dto);
        return (a);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        DocumentCaptureLogQueryDto dto = this.convertParams(params);
        Page<DocumentCaptureLogVo> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
        List<InvoiceMatchLogVo> invoiceMatchLogVos = new ArrayList<>();
        Page<InvoiceMatchLogVo> accStores = this.documentCaptureLogMapper.findAcceptanceCountData(pageable,dto);
        if (CollectionUtils.isNotEmpty(accStores.getRecords())){
            invoiceMatchLogVos.addAll(accStores.getRecords());
        }
        Page<InvoiceMatchLogVo> accProducts = this.documentCaptureLogMapper.findAcceptanceData(pageable,dto);
        if (CollectionUtils.isNotEmpty(accProducts.getRecords())){
            invoiceMatchLogVos.addAll(accProducts.getRecords());
        }
        return JSON.parseArray(JSON.toJSONString((invoiceMatchLogVos)));
    }

    @Override
    public Class<DocumentCaptureLogExportVo> findCrmExcelVoClass() {
        return DocumentCaptureLogExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "KMS_DOCUMENT_LOG_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "KMS单据抓取日志导出";
    }



    /**
     * 转换参数
     *
     * @param params 传递参数
     * @return 转换结果
     */
    private DocumentCaptureLogQueryDto convertParams(Map<String, Object> params) {
        DocumentCaptureLogExportDto dto = JSON.parseObject(JSON.toJSONString(params), DocumentCaptureLogExportDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        DocumentCaptureLogQueryDto documentCaptureLogQueryDto = new DocumentCaptureLogQueryDto();
        documentCaptureLogQueryDto.setKaCode(dto.getDirectCode());
        documentCaptureLogQueryDto.setKaName(dto.getDirectName());
        documentCaptureLogQueryDto.setInvoiceType(OrderTypeEnum.ACCEPTANCE.getDesc());
        return documentCaptureLogQueryDto;
    }


}
