package com.biz.crm.kms.business.document.capture.log.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigInteger;

/**
 * @Class DocumentCaptureLogExportVo
 * @Description 单据抓取日志导出Vo
 * @Author : ZS
 * @Date: 2023/2/25  13:35
 */
@Data
@ApiModel(value = "DocumentCaptureLogExportVo", description = "单据抓取日志导出Vo")
@CrmExcelExport
public class DocumentCaptureLogExportVo extends CrmExcelVo {

    @CrmExcelColumn("系统编码")
    private String directCode;

    @CrmExcelColumn("系统名称")
    private String directName;

    @CrmExcelColumn("零售商门店编码")
    private String kaStoreCode;

    @CrmExcelColumn("零售商门店名称")
    private String kaStoreName;

    @CrmExcelColumn("门店关联单据数据")
    private BigInteger storeInvoiceNum;

    @CrmExcelColumn("售达方名称")
    private String soldToPartyName;

    @CrmExcelColumn("售达方编码")
    private String soldToPartyCode;


    @CrmExcelColumn("零售商产品编码")
    private String kaProductCode;

    @CrmExcelColumn("零售商产品名称")
    private String kaProductName;

    @CrmExcelColumn("产品关联单据数据")
    private BigInteger productInvoiceNum;

}
