package com.biz.crm.kms.business.document.capture.log.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.DocumentCaptureLogVo;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.InvoiceMatchLogVo;
import org.apache.ibatis.annotations.Param;

/**
 * (DocumentCaptureLog)表mybatis访问层
 *
 * @author hd
 * @since 2023-01-10 11:05:25
 */
public interface DocumentCaptureLogMapper extends BaseMapper<DocumentCaptureLogEntity> {
    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询实体
     * @return 所有数据
     */
    Page<DocumentCaptureLogVo> findByConditions(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 抓取次数
     */
    Integer findGrabNum(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 抓取成功次数
     */
    Integer findSuccessNum(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 异常账号数量
     */
    Integer findAbnormalAccount(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 异常抓单任务数量
     */
    Integer findAbnormalGrabTask(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询验收单匹配失败门店数量
     */
    Integer findAcceptanceCount(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询验收单匹配失败产品数量
     */
    Integer findAcceptance(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 分页查询异常账号
     */
    Page<DocumentCaptureLogVo> findByAbnormal(@Param("page") Page<DocumentCaptureLogVo> page
            , @Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 分页查询抓取成功率
     */
//    Page<DocumentCaptureLogVo> findBySuccess(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 分页查询异常抓单任务
     */
    Page<DocumentCaptureLogVo> findByGrabTask(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询费用单匹配失败门店数量
     */
    Integer findExpenseCount(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询结算单匹配失败数量
     */
    Integer findStatementCount(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询库存数据匹配失败门店数量
     */
    Integer findStockCount(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询退货单匹配失败门店数量
     */
    Integer findReturnCount(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询post匹配失败门店数量
     */
    Integer findSalesCount(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询费用单匹配失败产品数量
     */
    Integer findExpense(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询库存数据匹配失败产品数量
     */
    Integer findStock(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询退货单匹配失败产品数量
     */
    Integer findReturn(@Param("dto") DocumentCaptureLogQueryDto dto);

    /**
     * 查询post匹配失败产品数量
     */
    Integer findSales(@Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findAcceptanceCountData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findExpenseCountData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findStatementCountData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findStockCountData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findReturnCountData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findSalesCountData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findAcceptanceData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findExpenseData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findStockData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findReturnData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findSalesData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    Page<InvoiceMatchLogVo> findStatementData(@Param("page") Page<DocumentCaptureLogVo> page, @Param("dto") DocumentCaptureLogQueryDto dto);

    void deleteLogByDate(@Param("three")String three);
}

