package com.biz.crm.kms.business.document.capture.log.local.repository;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.local.mapper.DocumentCaptureLogMapper;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.DocumentCaptureLogVo;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.InvoiceMatchLogVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;


/**
 * (DocumentCaptureLog)表数据库访问层
 *
 * @author hd
 * @since 2023-01-10 11:05:25
 */
@Component
public class DocumentCaptureLogRepository extends ServiceImpl<DocumentCaptureLogMapper, DocumentCaptureLogEntity> {
    @Autowired(required = false)
    private DocumentCaptureLogMapper documentCaptureLogMapper;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    public Page<DocumentCaptureLogVo> findByConditions(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findByConditions(page, dto);
    }

    /**
     * 通过日志编号查询单条数据
     *
     * @param logCode 日志编号
     * @return 单条数据
     */
    public DocumentCaptureLogEntity findByLogCode(String logCode) {
        if (StringUtils.isBlank(logCode)) {
            return null;
        }
        return lambdaQuery()
                .eq(DocumentCaptureLogEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(DocumentCaptureLogEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DocumentCaptureLogEntity::getLogCode, logCode)
                .one();
    }

    /**
     * 抓取次数
     */
    public Integer findGrabNum(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findGrabNum(dto);
    }

    /**
     * 抓取成功次数
     */
    public Integer findSuccessNum(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findSuccessNum(dto);
    }

    /**
     * 异常账号数量
     */
    public Integer findAbnormalAccount(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findAbnormalAccount(dto);
    }

    /**
     * 异常抓单任务数量
     */
    public Integer findAbnormalGrabTask(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findAbnormalGrabTask(dto);
    }

    /**
     * 查询验收单匹配失败门店数量
     */
    public Integer findAcceptanceCount(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findAcceptanceCount(dto);
    }

    /**
     * 查询验收单匹配失败产品数量
     */
    public Integer findAcceptance(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findAcceptance(dto);
    }

    /**
     * 分页查询抓取成功率
     */
//    public Page<DocumentCaptureLogVo> findBySuccess(Pageable pageable, DocumentCaptureLogQueryDto dto) {
//        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
//        return documentCaptureLogMapper.findBySuccess(page, dto);
//    }

    /**
     * 分页查询异常账号
     */
    public Page<DocumentCaptureLogVo> findByAbnormal(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findByAbnormal(page, dto);
    }

    /**
     * 分页查询异常抓单任务
     */
    public Page<DocumentCaptureLogVo> findByGrabTask(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findByGrabTask(page, dto);
    }

    /**
     * 查询费用单匹配失败门店数量
     */
    public Integer findExpenseCount(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findExpenseCount(dto);
    }

    /**
     * 查询结算单匹配失败数量
     */
    public Integer findStatementCount(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findStatementCount(dto);
    }

    /**
     * 查询库存数据匹配失败门店数量
     */
    public Integer findStockCount(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findStockCount(dto);
    }

    /**
     * 查询退货单匹配失败门店数量
     */
    public Integer findReturnCount(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findReturnCount(dto);
    }

    /**
     * 查询post匹配失败门店数量
     */
    public Integer findSalesCount(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findSalesCount(dto);
    }

    /**
     * 查询费用单匹配失败产品数量
     */
    public Integer findExpense(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findExpense(dto);
    }

    /**
     * 查询库存数据匹配失败产品数量
     */
    public Integer findStock(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findStock(dto);
    }

    /**
     * 查询退货单匹配失败产品数量
     */
    public Integer findReturn(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findReturn(dto);
    }

    /**
     * 查询post匹配失败产品数量
     */
    public Integer findSales(DocumentCaptureLogQueryDto dto) {
        return documentCaptureLogMapper.findSales(dto);
    }

    public Page<InvoiceMatchLogVo> findAcceptanceCountData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findAcceptanceCountData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findExpenseCountData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findExpenseCountData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findStatementCountData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findStatementCountData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findStockCountData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findStockCountData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findReturnCountData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findReturnCountData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findSalesCountData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findSalesCountData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findAcceptanceData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findAcceptanceData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findExpenseData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findExpenseData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findStockData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findStockData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findReturnData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findReturnData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findSalesData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findSalesData(page, dto);
    }

    public Page<InvoiceMatchLogVo> findStatementData(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        Page<DocumentCaptureLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return documentCaptureLogMapper.findStatementData(page, dto);
    }

    public void deleteLogByDate(String three) {
        if (StringUtils.isEmpty(three)){
            return;
        }
        documentCaptureLogMapper.deleteLogByDate(three);
    }
}

