package com.biz.crm.kms.business.document.capture.log.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.DocumentCaptureLogVo;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.InvoiceMatchLogVo;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.LogNumShowVo;
import org.springframework.data.domain.Pageable;

/**
 * (accountReceivable)表服务接口
 *
 * @author hd
 * @since 2023-01-10 11:05:25
 */
public interface DocumentCaptureLogService {


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    LogNumShowVo findByConditions(Pageable pageable, DocumentCaptureLogQueryDto dto);

    /**
     * 通过日志编号查询单条数据
     *
     * @param logCode 日志编号
     * @return 单条数据
     */
    DocumentCaptureLogEntity findByLogCode(String logCode);

    /**
     * 定时删除三月前的日志的定时任务
     */
    void deleteLog();

}
