package com.biz.crm.kms.business.document.capture.log.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.local.service.DocumentCaptureLogTransService;
import com.biz.crm.kms.business.document.capture.log.sdk.constant.DocumentCaptureLogConstant;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.GrabRequestSynchronizeDto;
import com.biz.crm.kms.business.document.capture.log.sdk.service.DocumentCaptureLogSynchronizeService;
import com.biz.crm.kms.business.grab.rule.sdk.constant.GrabRuleConstant;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.TimeUnit;

@Service("synchronizeService")
public class DocumentCaptureLogSynchronizeServiceImpl implements DocumentCaptureLogSynchronizeService {
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;
    @Autowired(required = false)
    private DocumentCaptureLogTransService documentCaptureLogTransService;

    @Override
    public void synchronize(List<GrabRequestSynchronizeDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<DocumentCaptureLogEntity> logList = new LinkedList<>();
        list.forEach(request -> {
            DocumentCaptureLogEntity logEntity = new DocumentCaptureLogEntity();
            logEntity.setLogDate(request.getTime());
            logEntity.setUuid(request.getUuidLog());
            String ruleCode = org.apache.commons.lang3.StringUtils.join(DocumentCaptureLogConstant.DOCUMENT_CAPTURE_LOG_PREFIX, DateFormatUtils.format(new Date(), "yyyyMMdd"));
            String logCode = generateCodeService.generateCode(ruleCode, 1, 5, 2, TimeUnit.DAYS).get(0);
            logEntity.setLogCode(logCode);
            String requestData = request.getRequest();
            if (StringUtils.isNotEmpty(requestData)) {
                JSONObject jsonObject = JSONObject.parseObject(requestData);
                JSONObject bodyJsonObject = JSONObject.parseObject(jsonObject.get(GrabRuleConstant.GRPC_REQ_BODY).toString());
                JSONObject dataJsonObject = JSONObject.parseObject(bodyJsonObject.get(GrabRuleConstant.GRPC_REQ_EXTEND_ARGS).toString());
                Map<String, String> extendParmMap = JSONObject.parseObject(dataJsonObject.get(GrabRuleConstant.GRPC_REQ_EXTEND_PARAM).toString(), Map.class);
                Map<String, Object> reqParmMap = JSONObject.parseObject(dataJsonObject.get(GrabRuleConstant.GRPC_REQ_REQ_PARAM).toString(), Map.class);
                if (!Objects.isNull(extendParmMap)) {
                    // 抓单规则
                    logEntity.setCaptureRule(extendParmMap.get(GrabRuleConstant.RULE_NAME));
                    logEntity.setDirectCode(extendParmMap.get(GrabRuleConstant.DIRECT_SYSTEM_ID));
                    logEntity.setGrabMode(extendParmMap.get(GrabRuleConstant.STYLE));
                    // 操作用户
                    logEntity.setNickName(extendParmMap.get(GrabRuleConstant.NICK_NAME));
                    logEntity.setTenantCode(extendParmMap.get(GrabRuleConstant.TENANTRY_ID));
                }
                if (ObjectUtils.isNotEmpty(reqParmMap)) {
                    Object itemType = reqParmMap.get(GrabRuleConstant.DOC);
                    if (!Objects.isNull(itemType)){
                        logEntity.setItemType(itemType.toString());
                    }
                    Object kaName = reqParmMap.get(GrabRuleConstant.KA_NAME);
                    if (!Objects.isNull(kaName)){
                        logEntity.setDirectName(kaName.toString());
                    }
                }
            }
            logList.add(logEntity);
        });
        documentCaptureLogTransService.saveDataList(logList);
        logList.clear();
    }
}
