package com.biz.crm.kms.business.document.capture.log.local.service.internal;

import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.local.repository.DocumentCaptureLogRepository;
import com.biz.crm.kms.business.document.capture.log.local.service.DocumentCaptureLogTransService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service("documentCaptureLogTransService")
public class DocumentCaptureLogTransServiceImpl implements DocumentCaptureLogTransService {
    @Autowired(required = false)
    private DocumentCaptureLogRepository documentCaptureLogRepository;

    /**
     * 批量保存
     *
     * @param saveList
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDataList(List<DocumentCaptureLogEntity> saveList) {
        documentCaptureLogRepository.saveBatch(saveList);
    }
}
