/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.document.capture.log.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.local.service.DocumentCaptureLogService;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.LogNumShowVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/documentCaptureLog/documentCaptureLog"})
@Api(tags={"KMS-\u5355\u636e\u6293\u53d6\u65e5\u5fd7"})
public class DocumentCaptureLogController {
    private static final Logger log = LoggerFactory.getLogger(DocumentCaptureLogController.class);
    @Autowired
    private DocumentCaptureLogService documentCaptureLogService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6293\u5355\u65e5\u5fd7\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<LogNumShowVo> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u6761\u4ef6") DocumentCaptureLogQueryDto dto) {
        try {
            LogNumShowVo page = this.documentCaptureLogService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{logCode}"})
    public Result<DocumentCaptureLogEntity> findByLogCode(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String logCode) {
        try {
            DocumentCaptureLogEntity logVo = this.documentCaptureLogService.findByLogCode(logCode);
            return Result.ok((Object)((Object)logVo));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

