/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.document.capture.log.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.document.capture.log.local.exports.dto.DocumentCaptureLogExportDto;
import com.biz.crm.kms.business.document.capture.log.local.exports.vo.DocumentCaptureLogExportVo;
import com.biz.crm.kms.business.document.capture.log.local.mapper.DocumentCaptureLogMapper;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.enums.OrderTypeEnum;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.DocumentCaptureLogVo;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.InvoiceMatchLogVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentCaptureLogExportProcess
implements ExportProcess<DocumentCaptureLogExportVo> {
    private static final Logger log = LoggerFactory.getLogger(DocumentCaptureLogExportProcess.class);
    @Autowired(required=false)
    private DocumentCaptureLogMapper documentCaptureLogMapper;

    public Integer getTotal(Map<String, Object> params) {
        DocumentCaptureLogQueryDto dto = this.convertParams(params);
        Integer a = this.documentCaptureLogMapper.findAcceptanceCount(dto) + this.documentCaptureLogMapper.findAcceptance(dto);
        return a;
    }

    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        Page<InvoiceMatchLogVo> accProducts;
        DocumentCaptureLogQueryDto dto = this.convertParams(params);
        Page pageable = new Page((long)processVo.getPageNo().intValue(), (long)this.getPageSize().intValue());
        ArrayList invoiceMatchLogVos = new ArrayList();
        Page<InvoiceMatchLogVo> accStores = this.documentCaptureLogMapper.findAcceptanceCountData((Page<DocumentCaptureLogVo>)pageable, dto);
        if (CollectionUtils.isNotEmpty((Collection)accStores.getRecords())) {
            invoiceMatchLogVos.addAll(accStores.getRecords());
        }
        if (CollectionUtils.isNotEmpty((Collection)(accProducts = this.documentCaptureLogMapper.findAcceptanceData((Page<DocumentCaptureLogVo>)pageable, dto)).getRecords())) {
            invoiceMatchLogVos.addAll(accProducts.getRecords());
        }
        return JSON.parseArray((String)JSON.toJSONString(invoiceMatchLogVos));
    }

    public Class<DocumentCaptureLogExportVo> findCrmExcelVoClass() {
        return DocumentCaptureLogExportVo.class;
    }

    public String getBusinessCode() {
        return "KMS_DOCUMENT_LOG_EXPORT";
    }

    public String getBusinessName() {
        return "KMS\u5355\u636e\u6293\u53d6\u65e5\u5fd7\u5bfc\u51fa";
    }

    private DocumentCaptureLogQueryDto convertParams(Map<String, Object> params) {
        DocumentCaptureLogExportDto dto = (DocumentCaptureLogExportDto)((Object)JSON.parseObject((String)JSON.toJSONString(params), DocumentCaptureLogExportDto.class));
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        DocumentCaptureLogQueryDto documentCaptureLogQueryDto = new DocumentCaptureLogQueryDto();
        documentCaptureLogQueryDto.setKaCode(dto.getDirectCode());
        documentCaptureLogQueryDto.setKaName(dto.getDirectName());
        documentCaptureLogQueryDto.setInvoiceType(OrderTypeEnum.ACCEPTANCE.getDesc());
        return documentCaptureLogQueryDto;
    }
}

