/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.document.capture.log.local.service.internal;

import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.local.repository.DocumentCaptureLogRepository;
import com.biz.crm.kms.business.document.capture.log.local.service.DocumentCaptureLogService;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.DocumentCaptureLogQueryDto;
import com.biz.crm.kms.business.document.capture.log.sdk.enums.OrderTypeEnum;
import com.biz.crm.kms.business.document.capture.log.sdk.vo.LogNumShowVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="documentCaptureLogService")
public class DocumentCaptureLogServiceImpl
implements DocumentCaptureLogService {
    private static final Logger log = LoggerFactory.getLogger(DocumentCaptureLogServiceImpl.class);
    @Autowired(required=false)
    private DocumentCaptureLogRepository documentCaptureLogRepository;

    @Override
    public LogNumShowVo findByConditions(Pageable pageable, DocumentCaptureLogQueryDto dto) {
        String invoiceType;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        dto = (DocumentCaptureLogQueryDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new DocumentCaptureLogQueryDto());
        String queryStartDate = dto.getQueryStartDate();
        String queryEndDate = dto.getQueryEndDate();
        LogNumShowVo logNumShowVo = new LogNumShowVo();
        dto.setInvoiceType(this.transOrderType(dto.getInvoiceType()));
        if (StringUtils.isEmpty((CharSequence)dto.getOperateMenu())) {
            Integer grabNum = this.documentCaptureLogRepository.findGrabNum(dto);
            logNumShowVo.setGrabNum(grabNum);
            logNumShowVo.setTotal(grabNum);
            if (ObjectUtils.isNotEmpty((Object)grabNum) && grabNum != 0) {
                Integer successNum = this.documentCaptureLogRepository.findSuccessNum(dto);
                logNumShowVo.setGrabSuccessRate(new BigDecimal(successNum).divide(new BigDecimal(grabNum), 2, 4));
            }
            logNumShowVo.setAbnormalAccount(this.documentCaptureLogRepository.findAbnormalAccount(dto));
            logNumShowVo.setAbnormalGrabTask(this.documentCaptureLogRepository.findAbnormalGrabTask(dto));
            logNumShowVo.setMatchFailStore(this.documentCaptureLogRepository.findAcceptanceCount(dto));
            logNumShowVo.setMatchFailProduct(this.documentCaptureLogRepository.findAcceptance(dto));
            logNumShowVo.setDocumentCaptureLogVos(this.documentCaptureLogRepository.findByConditions(pageable, dto).getRecords());
            return logNumShowVo;
        }
        String operateMenu = dto.getOperateMenu();
        Validate.notBlank((CharSequence)operateMenu, (String)"\u64cd\u4f5c\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)queryStartDate) && StringUtils.isNotEmpty((CharSequence)queryEndDate)) {
            Validate.isTrue((!DateUtil.parseDate((String)queryStartDate, (String)"yyyy-MM-dd").after(DateUtil.parseDate((String)queryEndDate, (String)"yyyy-MM-dd")) ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e\uff01", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)(invoiceType = dto.getInvoiceType()))) {
            invoiceType = "\u9a8c\u6536\u5355";
        }
        if ("grabNum".equals(operateMenu)) {
            Integer grabNum = this.documentCaptureLogRepository.findGrabNum(dto);
            logNumShowVo.setGrabNum(grabNum);
            logNumShowVo.setTotal(grabNum);
            logNumShowVo.setDocumentCaptureLogVos(this.documentCaptureLogRepository.findByConditions(pageable, dto).getRecords());
        } else if ("grabSuccessRate".equals(operateMenu)) {
            Integer grabNum = this.documentCaptureLogRepository.findGrabNum(dto);
            logNumShowVo.setTotal(grabNum);
            if (ObjectUtils.isNotEmpty((Object)grabNum) && grabNum != 0) {
                Integer successNum = this.documentCaptureLogRepository.findSuccessNum(dto);
                logNumShowVo.setGrabSuccessRate(new BigDecimal(successNum).divide(new BigDecimal(grabNum).multiply(new BigDecimal(100)), 1, 4));
            }
            logNumShowVo.setDocumentCaptureLogVos(this.documentCaptureLogRepository.findByConditions(pageable, dto).getRecords());
        } else if ("abnormalAccount".equals(operateMenu)) {
            Integer abnormalAccount = this.documentCaptureLogRepository.findAbnormalAccount(dto);
            logNumShowVo.setAbnormalAccount(abnormalAccount);
            logNumShowVo.setTotal(abnormalAccount);
            logNumShowVo.setDocumentCaptureLogVos(this.documentCaptureLogRepository.findByAbnormal(pageable, dto).getRecords());
        } else if ("abnormalGrabTask".equals(operateMenu)) {
            Integer abnormalGrabTask = this.documentCaptureLogRepository.findAbnormalGrabTask(dto);
            logNumShowVo.setAbnormalGrabTask(abnormalGrabTask);
            logNumShowVo.setTotal(abnormalGrabTask);
            logNumShowVo.setDocumentCaptureLogVos(this.documentCaptureLogRepository.findByGrabTask(pageable, dto).getRecords());
        } else {
            logNumShowVo = "matchFailStore".equals(operateMenu) ? this.failStore(pageable, dto, logNumShowVo, invoiceType) : this.failProduct(pageable, dto, logNumShowVo, invoiceType);
        }
        return logNumShowVo;
    }

    private DocumentCaptureLogQueryDto dateData(DocumentCaptureLogQueryDto dto, String queryStartDate, String queryEndDate) {
        if (StringUtils.isEmpty((CharSequence)queryStartDate) && StringUtils.isEmpty((CharSequence)queryEndDate)) {
            String startDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd").concat(" 00:00:00");
            String date = DateUtil.format((Date)DateUtil.ReturnTheDay((Date)new Date(), (int)1), (String)"yyyy-MM-dd").concat(" 00:00:00");
            dto.setQueryStartDate(startDate);
            dto.setQueryEndDate(date);
        } else if (StringUtils.isNotEmpty((CharSequence)queryEndDate)) {
            try {
                Date date = DateUtil.date_yyyy_MM_dd_HH_mm_ss.parse(queryEndDate);
                queryEndDate = DateUtil.format((Date)DateUtil.ReturnTheDay((Date)date, (int)1), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            dto.setQueryEndDate(queryEndDate);
        }
        return dto;
    }

    private LogNumShowVo failStore(Pageable pageable, DocumentCaptureLogQueryDto dto, LogNumShowVo logNumShowVo, String invoiceType) {
        if (OrderTypeEnum.ACCEPTANCE.getDesc().equals(invoiceType)) {
            Integer acceptanceCount = this.documentCaptureLogRepository.findAcceptanceCount(dto);
            logNumShowVo.setMatchFailStore(acceptanceCount);
            logNumShowVo.setTotal(acceptanceCount);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findAcceptanceCountData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.EXPENSE.getDesc().equals(invoiceType)) {
            Integer expenseCount = this.documentCaptureLogRepository.findExpenseCount(dto);
            logNumShowVo.setMatchFailStore(expenseCount);
            logNumShowVo.setTotal(expenseCount);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findExpenseCountData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.STATEMENT.getDesc().equals(invoiceType)) {
            Integer statementCount = this.documentCaptureLogRepository.findStatementCount(dto);
            logNumShowVo.setMatchFailStore(statementCount);
            logNumShowVo.setTotal(statementCount);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findStatementCountData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.STOCK.getDesc().equals(invoiceType)) {
            Integer stockCount = this.documentCaptureLogRepository.findStockCount(dto);
            logNumShowVo.setMatchFailStore(stockCount);
            logNumShowVo.setTotal(stockCount);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findStockCountData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.RETURN.getDesc().equals(invoiceType)) {
            Integer returnCount = this.documentCaptureLogRepository.findReturnCount(dto);
            logNumShowVo.setMatchFailStore(returnCount);
            logNumShowVo.setTotal(returnCount);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findReturnCountData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.SALE.getDesc().equals(invoiceType)) {
            Integer salesCount = this.documentCaptureLogRepository.findSalesCount(dto);
            logNumShowVo.setMatchFailStore(salesCount);
            logNumShowVo.setTotal(salesCount);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findSalesCountData(pageable, dto).getRecords());
        }
        return logNumShowVo;
    }

    private LogNumShowVo failProduct(Pageable pageable, DocumentCaptureLogQueryDto dto, LogNumShowVo logNumShowVo, String invoiceType) {
        if (OrderTypeEnum.ACCEPTANCE.getDesc().equals(invoiceType)) {
            Integer acceptance = this.documentCaptureLogRepository.findAcceptance(dto);
            logNumShowVo.setMatchFailStore(acceptance);
            logNumShowVo.setTotal(acceptance);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findAcceptanceData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.EXPENSE.getDesc().equals(invoiceType)) {
            Integer expense = this.documentCaptureLogRepository.findExpense(dto);
            logNumShowVo.setMatchFailStore(expense);
            logNumShowVo.setTotal(expense);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findExpenseData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.STATEMENT.getDesc().equals(invoiceType)) {
            Integer statementCount = this.documentCaptureLogRepository.findStatementCount(dto);
            logNumShowVo.setMatchFailStore(statementCount);
            logNumShowVo.setTotal(statementCount);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findStatementData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.STOCK.getDesc().equals(invoiceType)) {
            Integer stock = this.documentCaptureLogRepository.findStock(dto);
            logNumShowVo.setMatchFailStore(stock);
            logNumShowVo.setTotal(stock);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findStockData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.RETURN.getDesc().equals(invoiceType)) {
            Integer aReturn = this.documentCaptureLogRepository.findReturn(dto);
            logNumShowVo.setMatchFailStore(aReturn);
            logNumShowVo.setTotal(aReturn);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findReturnData(pageable, dto).getRecords());
        } else if (OrderTypeEnum.SALE.getDesc().equals(invoiceType)) {
            Integer sales = this.documentCaptureLogRepository.findSales(dto);
            logNumShowVo.setMatchFailStore(sales);
            logNumShowVo.setTotal(sales);
            logNumShowVo.setMatchLogVos(this.documentCaptureLogRepository.findSalesData(pageable, dto).getRecords());
        }
        return logNumShowVo;
    }

    private String transOrderType(String orderTypeCode) {
        if (StringUtils.isEmpty((CharSequence)orderTypeCode)) {
            return null;
        }
        String orderTypeDesc = null;
        if (OrderTypeEnum.ACCEPTANCE.getDictCode().equals(orderTypeCode)) {
            orderTypeDesc = OrderTypeEnum.ACCEPTANCE.getDesc();
        } else if (OrderTypeEnum.RETURN.getDictCode().equals(orderTypeCode)) {
            orderTypeDesc = OrderTypeEnum.RETURN.getDesc();
        } else if (OrderTypeEnum.EXPENSE.getDictCode().equals(orderTypeCode)) {
            orderTypeDesc = OrderTypeEnum.EXPENSE.getDesc();
        } else if (OrderTypeEnum.STATEMENT.getDictCode().equals(orderTypeCode)) {
            orderTypeDesc = OrderTypeEnum.STATEMENT.getDesc();
        } else if (OrderTypeEnum.STOCK.getDictCode().equals(orderTypeCode)) {
            orderTypeDesc = OrderTypeEnum.STOCK.getDesc();
        } else if (OrderTypeEnum.SALE.getDictCode().equals(orderTypeCode)) {
            orderTypeDesc = OrderTypeEnum.SALE.getDesc();
        }
        return orderTypeDesc;
    }

    @Override
    public DocumentCaptureLogEntity findByLogCode(String logCode) {
        if (StringUtils.isBlank((CharSequence)logCode)) {
            return null;
        }
        return this.documentCaptureLogRepository.findByLogCode(logCode);
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 23 * * ?", taskDesc="\u5220\u9664\u4e09\u6708\u524d\u7684\u65e5\u5fd7")
    public void deleteLog() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, -3);
        String three = format.format(c.getTime());
        this.documentCaptureLogRepository.deleteLogByDate(three);
    }
}

