/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.document.capture.log.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.kms.business.document.capture.log.local.entity.DocumentCaptureLogEntity;
import com.biz.crm.kms.business.document.capture.log.local.service.DocumentCaptureLogTransService;
import com.biz.crm.kms.business.document.capture.log.sdk.dto.GrabRequestSynchronizeDto;
import com.biz.crm.kms.business.document.capture.log.sdk.service.DocumentCaptureLogSynchronizeService;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="synchronizeService")
public class DocumentCaptureLogSynchronizeServiceImpl
implements DocumentCaptureLogSynchronizeService {
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private DocumentCaptureLogTransService documentCaptureLogTransService;

    public void synchronize(List<GrabRequestSynchronizeDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        LinkedList<DocumentCaptureLogEntity> logList = new LinkedList<DocumentCaptureLogEntity>();
        list.forEach(request -> {
            DocumentCaptureLogEntity logEntity = new DocumentCaptureLogEntity();
            logEntity.setLogDate(request.getTime());
            logEntity.setUuid(request.getUuidLog());
            String ruleCode = StringUtils.join((Object[])new String[]{"DCL", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            String logCode = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            logEntity.setLogCode(logCode);
            String requestData = request.getRequest();
            if (StringUtils.isNotEmpty((CharSequence)requestData)) {
                JSONObject jsonObject = JSONObject.parseObject((String)requestData);
                JSONObject bodyJsonObject = JSONObject.parseObject((String)jsonObject.get((Object)"body").toString());
                JSONObject dataJsonObject = JSONObject.parseObject((String)bodyJsonObject.get((Object)"extend_args").toString());
                Map extendParmMap = (Map)JSONObject.parseObject((String)dataJsonObject.get((Object)"extend_parm").toString(), Map.class);
                Map reqParmMap = (Map)JSONObject.parseObject((String)dataJsonObject.get((Object)"req_parm").toString(), Map.class);
                if (!Objects.isNull(extendParmMap)) {
                    logEntity.setCaptureRule((String)extendParmMap.get("rule_name"));
                    logEntity.setDirectCode((String)extendParmMap.get("direct_system_id"));
                    logEntity.setGrabMode((String)extendParmMap.get("style"));
                    logEntity.setNickName((String)extendParmMap.get("nick_name"));
                    logEntity.setTenantCode((String)extendParmMap.get("tenantry_id"));
                }
                if (ObjectUtils.isNotEmpty((Object)reqParmMap)) {
                    Object kaName;
                    Object itemType = reqParmMap.get("doc");
                    if (!Objects.isNull(itemType)) {
                        logEntity.setItemType(itemType.toString());
                    }
                    if (!Objects.isNull(kaName = reqParmMap.get("ka_name"))) {
                        logEntity.setDirectName(kaName.toString());
                    }
                }
            }
            logList.add(logEntity);
        });
        this.documentCaptureLogTransService.saveDataList(logList);
        logList.clear();
    }
}

