package com.biz.crm.kms.business.document.capture.log.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * 抓单日志查询条件Dto
 */
@Data
@ApiModel(value = "DocumentCaptureLogQueryDto", description = "单据抓取日志查询条件")
public class DocumentCaptureLogQueryDto {

    @ApiModelProperty(name = "开始时间(yyyy-MM-dd HH:mm:ss)")
    private String queryStartDate;

    @ApiModelProperty(name = "结束时间(yyyy-MM-dd HH:mm:ss)")
    private String queryEndDate;

    @ApiModelProperty(name = "商超名称")
    private String kaName;

    @ApiModelProperty(name = "商超编码")
    private String kaCode;

    @ApiModelProperty(name = "单据类型")
    private String invoiceType;

    @ApiModelProperty(name = "操作菜单")
    private String operateMenu;

    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    @Column(name = "sales_org_name")
    private String salesOrgName;

}
