package com.biz.crm.kms.business.document.capture.log.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

/**
 * @author hd
 * @create 2023-01-13 9:50:12
 * @description：单据抓取日志vo
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DocumentCaptureLogVo", description = "TPM-单据抓取日志")
public class  DocumentCaptureLogVo extends TenantFlagOpVo {
    /**
     * 时间(yyyy-MM-dd HH:mm:ss)
     */
    @ApiModelProperty(name = "时间(yyyy-MM-dd HH:mm:ss)")
    @Column(name = "log_date")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date LogDate;
    /**
     * 日志编号
     */
    @ApiModelProperty(name = "日志编号")
    @Column(name = "log_code")
    private String logCode;
    /**
     * 登录账号
     */
    @ApiModelProperty(name = "登录账号")
    @Column(name = "login_id")
    private String loginId;
    /**
     * 单据类型
     */
    @ApiModelProperty(name = "单据类型")
    @Column(name = "item_type")
    private String itemType;
    /**
     * 抓单规则
     */
    @ApiModelProperty(name = "抓单规则")
    @Column(name = "capture_rule")
    private String captureRule;
    /**
     * 抓取方式
     */
    @ApiModelProperty(name = "抓取方式")
    @Column(name = "grab_mode")
    private String grabMode;
    /**
     * 抓取状态
     */
    @ApiModelProperty(name = "抓取状态")
    @Column(name = "grab_status")
    private String grabStatus;
    /**
     * 解析状态
     */
    @ApiModelProperty(name = "解析状态")
    @Column(name = "parse_status")
    private String parseStatus;
    /**
     * 转换状态
     */
    @ApiModelProperty(name = "转换状态")
    @Column(name = "transition_status")
    private String transitionStatus;
    /**
     * 处理结果
     */
    @ApiModelProperty(name = "处理结果")
    @Column(name = "handle_result")
    private String handleResult;
    /**
     * 账号备注
     */
    @ApiModelProperty(name = "账号备注")
    @Column(name = "account_remark")
    private String accountRemark;
    /**
     * 直营体系
     */
    @ApiModelProperty("直营体系编码")
    @Column(name = "direct_code")
    private String directCode;
    /**
     * 直营体系名称
     */
    @ApiModelProperty("直营体系名称")
    @Column(name = "direct_name")
    private String directName;
    /**
     * 相关单据抓取任务数量
     */
    @ApiModelProperty("相关单据抓取任务数量")
    @Column(name = "doc_relate_crawl_job_num")
    private Integer docRelateCrawlJobNum;
    /**
     * 异常登陆次数
     */
    @ApiModelProperty("异常登陆次数")
    @Column(name = "abnormal_login_num")
    private Integer abnormalLoginNum;
    /**
     * 抓单任务名称
     */
    @ApiModelProperty(name = "抓单任务名称")
    @Column(name = "grab_task_name")
    private String grabTaskName;
    /**
     * 抓单时间
     */
    @ApiModelProperty(name = "抓单时间")
    @Column(name = "grab_time")
    private String grabTime;
    /**
     * 抓单时间间隔
     */
    @ApiModelProperty(name = "抓单时间间隔")
    @Column(name = "grab_time_interval")
    private String grabTimeInterval;
    /**
     * 近三天异常次数
     */
    @ApiModelProperty(name = "近三天异常次数")
    @Column(name = "three_day_anomaly_num")
    private Integer threeDayAnomalyNum;
    /**
     * 商超系统登录结果
     */
    @ApiModelProperty(name = "登录结果")
    @Column(name = "supermarket_login_result")
    private String supermarketLoginResult;
    /**
     * 商超系统登录返回信息
     */
    @ApiModelProperty(name = "返回信息")
    @Column(name = "supermarket_login_return_msg")
    private String supermarketLoginReturnMsg;
    /**
     * 原始数量
     */
    @ApiModelProperty(name = "原始数量")
    @Column(name = "original_num")
    private Integer originalNum;
    /**
     * 抓取数量
     */
    @ApiModelProperty(name = "抓取数量")
    @Column(name = "grab_num")
    private Integer grabNum;
    /**
     * 抓取成功
     */
    @ApiModelProperty(name = "抓取成功")
    @Column(name = "grab_succeed_num")
    private Integer grabSucceedNum;
    /**
     * 抓取失败
     */
    @ApiModelProperty(name = "抓取失败")
    @Column(name = "grab_fail_num")
    private Integer grabFailNum;
    /**
     * UUID(PYTHON需要字段)
     */
    @ApiModelProperty("UUID(PYTHON需要字段)")
    @Column(name = "uuid")
    private String uuid;
    /**
     * 操作用户
     */
    @ApiModelProperty(name = "操作用户")
    @Column(name = "nick_name")
    private String nickName;
    /**
     * 网址
     */
    @ApiModelProperty(name = "网址")
    @Column(name = "site_url")
    private String siteUrl;

    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code")
    private String salesOrgCode;

    @TableField(value = "sales_org_name")
    @Column(name = "sales_org_name")
    private String salesOrgName;
}
