package com.biz.crm.kms.business.document.capture.log.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigInteger;

/**
 * 单据匹配结果日志vo
 */
@Data
@ApiModel(value = "InvoiceMatchLogVo", description = "单据匹配结果日志vo")
public class InvoiceMatchLogVo {

    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code")
    private String salesOrgCode;

    @TableField(value = "sales_org_name")
    @Column(name = "sales_org_name")
    private String salesOrgName;

    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code")
    private String soldToPartyCode;

    @ApiModelProperty("系统编码")
    @Column(name = "direct_code")
    private String directCode;

    @ApiModelProperty("系统名称")
    @Column(name = "direct_name")
    private String directName;

    @ApiModelProperty("零售商门店编码")
    @Column(name = "ka_store_code")
    private String kaStoreCode;

    @ApiModelProperty("零售商门店名称")
    @Column(name = "ka_store_name")
    private String kaStoreName;

    @ApiModelProperty("单据编码")
    @Column(name = "order_number")
    private String orderNumber;

    @ApiModelProperty("零售商产品编码")
    @Column(name = "ka_product_code")
    private String kaProductCode;

    @ApiModelProperty("零售商产品名称")
    @Column(name = "ka_product_name")
    private String kaProductName;

    @ApiModelProperty("产品关联单据数据")
    private BigInteger productInvoiceNum;

    @ApiModelProperty("门店关联单据数据")
    private BigInteger storeInvoiceNum;
}
