package com.biz.crm.kms.business.document.capture.log.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 日志展示vo
 */
@Data
@ApiModel(value = "LogNumShowVo", description = "日志展示vo")
public class LogNumShowVo {

    /**
     * 抓取次数
     */
    @ApiModelProperty("抓取次数")
    private Integer grabNum;
    /**
     * 抓单成功率
     */
    @ApiModelProperty("抓单成功率")
    private BigDecimal grabSuccessRate;
    /**
     * 异常账号
     */
    @ApiModelProperty("异常账号")
    private Integer abnormalAccount;
    /**
     * 异常抓单任务
     */
    @ApiModelProperty("异常抓单任务")
    private Integer abnormalGrabTask;
    /**
     * 匹配失败门店
     */
    @ApiModelProperty("匹配失败门店")
    private Integer matchFailStore;
    /**
     * 匹配失败产品
     */
    @ApiModelProperty("匹配失败产品")
    private Integer matchFailProduct;
    /**
     * 匹配失败数据
     */
    @ApiModelProperty("匹配失败数据")
    private List<InvoiceMatchLogVo> matchLogVos;
    /**
     * 抓单日志数据
     */
    @ApiModelProperty("抓单日志数据")
    private List<DocumentCaptureLogVo> documentCaptureLogVos;
    /**
     * 总条数
     */
    @ApiModelProperty("数据总条数")
    private Integer total;
}
