/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.financial.auditing.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.financial.auditing.sdk.dto.ToTpmDto;
import com.biz.crm.kms.business.financial.auditing.sdk.service.AuditService;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.AuditVo;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.DeliveryOrSoldVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/audit/audit"})
@Api(tags={"\u7a3d\u6838\u6838\u5b9a"})
public class AuditController {
    private static final Logger log = LoggerFactory.getLogger(AuditController.class);
    @Autowired
    private AuditService auditService;

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<AuditVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            AuditVo audit = this.auditService.findById(id);
            return Result.ok((Object)audit);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<AuditVo> create(@ApiParam(name="audit", value="") @RequestBody AuditVo audit) {
        try {
            AuditVo result = this.auditService.create(audit);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<AuditVo> update(@ApiParam(name="audit", value="") @RequestBody AuditVo audit) {
        try {
            AuditVo result = this.auditService.update(audit);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.auditService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.auditService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.auditService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"matchToTPM"})
    @ApiOperation(value="\u6279\u91cf\u63a8\u9001TPM")
    public Result matchToTPM(@ApiParam(name="toTpmDto", value="\u6279\u91cf\u63a8\u9001TPM_DTO") @RequestBody ToTpmDto toTpmDto) {
        try {
            this.auditService.matchToTPM(toTpmDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findSoldToPartyByAudit"})
    @ApiOperation(value="\u67e5\u8be2\u7a3d\u6838\u6838\u5b9a\u552e\u8fbe\u65b9")
    public Result<Page<DeliveryOrSoldVo>> findSoldToPartyByAudit(@PageableDefault(value=50) Pageable pageable) {
        try {
            Page deliveryOrSoldVoList = this.auditService.findSoldToPartyByAudit(pageable);
            return Result.ok((Object)deliveryOrSoldVoList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findDeliverPartyByAudit"})
    @ApiOperation(value="\u67e5\u8be2\u7a3d\u6838\u6838\u5b9a\u9001\u8fbe\u65b9")
    public Result<Page<DeliveryOrSoldVo>> findDeliverPartyByAudit(@PageableDefault(value=50) Pageable pageable) {
        try {
            Page deliveryOrSoldVoList = this.auditService.findDeliveryPartyByAudit(pageable);
            return Result.ok((Object)deliveryOrSoldVoList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

