/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.financial.auditing.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.financial.auditing.local.entity.Audit;
import com.biz.crm.kms.business.financial.auditing.local.mapper.AuditMapper;
import com.biz.crm.kms.business.financial.auditing.sdk.dto.ConditionsDto;
import com.biz.crm.kms.business.financial.auditing.sdk.dto.ToTpmDto;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.AuditVo;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.DeliveryOrSoldVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditRepository
extends ServiceImpl<AuditMapper, Audit> {
    @Autowired(required=false)
    private AuditMapper auditMapper;

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public List<Audit> findAuditToTpm(ToTpmDto toTpmDto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).between(Audit::getApprovalDate, (Object)toTpmDto.getApprovalDateStart(), (Object)toTpmDto.getApprovalDateEnd())).eq(Audit::getSoldToPartyCode, (Object)toTpmDto.getSoldToPartyCode())).eq(Audit::getDeliveryPartyCode, (Object)toTpmDto.getDeliveryPartyCode())).eq(Audit::getDifferType, (Object)toTpmDto.getDifferType())).list();
    }

    public AuditVo findOneByConditions(ConditionsDto dto) {
        return this.auditMapper.findOneByConditions(dto);
    }

    public Page<DeliveryOrSoldVo> findSoldToPartyByAudit(Pageable pageable) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((AuditMapper)this.baseMapper).findSoldToPartyByAudit((Page<DeliveryOrSoldVo>)page);
    }

    public Page<DeliveryOrSoldVo> findDeliveryPartyByAudit(Pageable pageable) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((AuditMapper)this.baseMapper).findDeliveryPartyByAudit((Page<DeliveryOrSoldVo>)page);
    }

    public Page<AuditVo> findAuditMatchPageByParams(Pageable pageable, List<String> soldPartyCodes, String beginDate, String endDate) {
        if (!CollectionUtils.isEmpty(soldPartyCodes) && StringUtils.isEmpty((CharSequence)beginDate) && StringUtils.isEmpty((CharSequence)endDate)) {
            return null;
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((AuditMapper)this.baseMapper).findAuditPageByParams((Page<AuditVo>)page, soldPartyCodes, beginDate, endDate);
    }
}

