/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.financial.auditing.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchResultEnum;
import com.biz.crm.kms.business.financial.auditing.local.entity.Audit;
import com.biz.crm.kms.business.financial.auditing.local.repository.AuditRepository;
import com.biz.crm.kms.business.financial.auditing.sdk.dto.ConditionsDto;
import com.biz.crm.kms.business.financial.auditing.sdk.dto.ToTpmDto;
import com.biz.crm.kms.business.financial.auditing.sdk.service.AuditService;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.AuditVo;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.DeliveryOrSoldVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="auditService")
public class AuditServiceImpl
implements AuditService {
    @Autowired
    private AuditRepository auditRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public AuditVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.eneityTransforVo((Audit)((Object)this.auditRepository.getById((Serializable)((Object)id))));
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditVo create(AuditVo vo) {
        Audit audit = this.voTransforEntity(vo);
        this.createValidate(audit);
        audit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        audit.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        audit.setTenantCode(TenantUtils.getTenantCode());
        this.auditRepository.saveOrUpdate((Object)audit);
        return this.eneityTransforVo(audit);
    }

    public List<AuditVo> createBatch(List<AuditVo> auditVoList) {
        for (AuditVo auditVo : auditVoList) {
            this.create(auditVo);
        }
        return auditVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditVo update(AuditVo vo) {
        Audit audit = this.voTransforEntity(vo);
        this.updateValidate(audit);
        this.auditRepository.saveOrUpdate((Object)audit);
        return this.eneityTransforVo(audit);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.auditRepository.removeByIds(idList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.auditRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.auditRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    public void matchToTPM(ToTpmDto toTpmDto) {
        this.toTpmValidate(toTpmDto);
        List<Audit> auditToTpm = this.auditRepository.findAuditToTpm(toTpmDto);
        Validate.isTrue((!CollectionUtils.isEmpty(auditToTpm) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6838\u5b9a\u6570\u636e!", (Object[])new Object[0]);
        List noDiffer = auditToTpm.stream().filter(vo -> StringUtils.equals((CharSequence)MatchResultEnum.NO.getDictCode(), (CharSequence)vo.getMatchConsequence())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(noDiffer), (String)"\u8981\u63a8\u9001\u7684\u6570\u636e\u4e2d\u5305\u542b\u65e0\u5dee\u5f02\u7684\u6570\u636e,\u65e0\u6cd5\u8fdb\u884c\u6279\u91cf\u63a8\u9001!", (Object[])new Object[0]);
        BigDecimal amount = BigDecimal.ZERO;
        for (Audit audit : auditToTpm) {
            amount = amount.add(audit.getAmountVariance());
        }
        HashMap<String, BigDecimal> differAmount = new HashMap<String, BigDecimal>();
        differAmount.put(this.buildDifferAmountKey(toTpmDto), amount);
    }

    public AuditVo findOneByConditions(ConditionsDto dto) {
        Validate.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getKaCode()) && StringUtils.isBlank((CharSequence)dto.getKaName()) && StringUtils.isBlank((CharSequence)dto.getSoldToPartyCode()) && StringUtils.isBlank((CharSequence)dto.getSoldToPartyName())) {
            return null;
        }
        return this.auditRepository.findOneByConditions(dto);
    }

    public Page<AuditVo> findAuditByPage(Pageable pageable, List<String> soldPartyCodes, String beginDate, String endDate) {
        return this.auditRepository.findAuditMatchPageByParams(pageable, soldPartyCodes, beginDate, endDate);
    }

    public Page<DeliveryOrSoldVo> findSoldToPartyByAudit(Pageable pageable) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        return this.auditRepository.findSoldToPartyByAudit(pageable);
    }

    public Page<DeliveryOrSoldVo> findDeliveryPartyByAudit(Pageable pageable) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        return this.auditRepository.findDeliveryPartyByAudit(pageable);
    }

    private String buildDifferAmountKey(ToTpmDto toTpmDto) {
        return StringUtils.joinWith((String)"_", (Object[])new Object[]{toTpmDto.getSoldToPartyCode(), toTpmDto.getDeliveryPartyCode(), toTpmDto.getBudgetDataType(), toTpmDto.getActivityForm(), toTpmDto.getDifferType()});
    }

    private void toTpmValidate(ToTpmDto toTpmDto) {
        Validate.notNull((Object)toTpmDto, (String)"\u63a8\u9001TPM\u65f6,\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)toTpmDto.getSoldToPartyCode(), (String)"\u63a8\u9001TPM\u65f6,\u552e\u8fbe\u65b9\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)toTpmDto.getDeliveryPartyCode(), (String)"\u63a8\u9001TPM\u65f6,\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)toTpmDto.getApprovalDateStart(), (String)"\u63a8\u9001TPM\u65f6\uff0c\u6838\u5b9a\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)toTpmDto.getApprovalDateEnd(), (String)"\u63a8\u9001TPM\u65f6\uff0c\u6838\u5b9a\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)toTpmDto.getBudgetDataType(), (String)"\u63a8\u9001TPM\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)toTpmDto.getActivityForm(), (String)"\u63a8\u9001TPM\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)toTpmDto.getDifferType(), (String)"\u63a8\u9001TPM\u65f6\uff0c\u5dee\u5f02\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createValidate(Audit audit) {
        Validate.notNull((Object)((Object)audit), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        audit.setId(null);
    }

    private void updateValidate(Audit audit) {
        Validate.notNull((Object)((Object)audit), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private AuditVo eneityTransforVo(Audit entity) {
        if (!Objects.nonNull((Object)entity)) {
            return new AuditVo();
        }
        AuditVo vo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vo;
    }

    private Audit voTransforEntity(AuditVo vo) {
        if (!Objects.nonNull(vo)) {
            return new Audit();
        }
        Audit entity = (Audit)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, Audit.class, HashSet.class, ArrayList.class, new String[0]));
        return entity;
    }
}

