/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.financial.auditing.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.financial.auditing.local.entity.NotMatched;
import com.biz.crm.kms.business.financial.auditing.local.repository.NotMatchedRepository;
import com.biz.crm.kms.business.financial.auditing.sdk.service.NotMatchedService;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.NotMatchedVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="notMatchedService")
public class NotMatchedServiceImpl
implements NotMatchedService {
    @Autowired
    private NotMatchedRepository notMatchedRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public NotMatchedVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.eneityTransforVo((NotMatched)((Object)this.notMatchedRepository.getById((Serializable)((Object)id))));
    }

    @Transactional(rollbackFor={Exception.class})
    public NotMatchedVo create(NotMatchedVo vo) {
        NotMatched notMatched = this.voTransforEntity(vo);
        this.createValidate(notMatched);
        notMatched.setTenantCode(TenantUtils.getTenantCode());
        notMatched.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        notMatched.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.notMatchedRepository.saveOrUpdate((Object)notMatched);
        return this.eneityTransforVo(notMatched);
    }

    @Transactional(rollbackFor={Exception.class})
    public NotMatchedVo update(NotMatchedVo vo) {
        NotMatched notMatched = this.voTransforEntity(vo);
        this.updateValidate(notMatched);
        this.notMatchedRepository.saveOrUpdate((Object)notMatched);
        return this.eneityTransforVo(notMatched);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.notMatchedRepository.removeByIds(idList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.notMatchedRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.notMatchedRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    private void createValidate(NotMatched notMatched) {
        Validate.notNull((Object)((Object)notMatched), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getOrderNumber(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4f01\u4e1a\u9a8c\u6536\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getCustomerNumber(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u9a8c\u6536\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getTerminalCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4f01\u4e1a\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getProductCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4f01\u4e1a\u4ea7\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getAcceptanceDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9a8c\u6536\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)notMatched.getAcceptanceAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9a8c\u6536\uff08\u542b\u7a0e\uff09\u91d1\u989d", (Object[])new Object[0]);
        Validate.notNull((Object)notMatched.getAcceptanceAmountNot(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9a8c\u6536\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        notMatched.setId(null);
    }

    private void updateValidate(NotMatched notMatched) {
        Validate.notNull((Object)((Object)notMatched), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getOrderNumber(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4f01\u4e1a\u9a8c\u6536\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getCustomerNumber(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u9a8c\u6536\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getTerminalCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4f01\u4e1a\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getProductCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4f01\u4e1a\u4ea7\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notMatched.getAcceptanceDate(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9a8c\u6536\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)notMatched.getAcceptanceAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9a8c\u6536\uff08\u542b\u7a0e\uff09\u91d1\u989d", (Object[])new Object[0]);
        Validate.notNull((Object)notMatched.getAcceptanceAmountNot(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9a8c\u6536\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private NotMatchedVo eneityTransforVo(NotMatched entity) {
        if (entity != null) {
            return new NotMatchedVo();
        }
        NotMatchedVo vo = (NotMatchedVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, NotMatchedVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vo;
    }

    private NotMatched voTransforEntity(NotMatchedVo vo) {
        if (vo != null) {
            return new NotMatched();
        }
        NotMatched entity = (NotMatched)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, NotMatched.class, HashSet.class, ArrayList.class, new String[0]));
        return entity;
    }
}

