package com.biz.crm.kms.business.grab.rule.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.grab.rule.local.entity.GrabRuleEntity;
import com.biz.crm.kms.business.grab.rule.local.service.GrabRuleService;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRuleDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 抓单规则: GrabRule: 抓单规则配置
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Slf4j
@RestController
@RequestMapping("/v1/grabRule/grabRule")
@Api(tags = "抓单规则: GrabRule: 抓单规则配置")
public class GrabRuleController {

  @Autowired
  private GrabRuleService grabRuleService;

  /**
   * 新增抓单规则信息
   *
   * @param dto 参数dto
   * @return 新增抓单规则数据
   */
  @ApiOperation(value = "新增抓单规则")
  @PostMapping("")
  public Result<GrabRuleEntity> create(@RequestBody GrabRuleDto dto) {
    try {
      return Result.ok(this.grabRuleService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新抓单规则信息
   *
   * @param dto 参数dto
   * @return 更新后抓单规则数据
   */
  @ApiOperation(value = "更新抓单规则信息")
  @PatchMapping("")
  public Result<GrabRuleEntity> update(@RequestBody GrabRuleDto dto) {
    try {
      return Result.ok(this.grabRuleService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动抓取
   *
   * @param dto 请求参数dto
   */
  @ApiOperation(value = "手动抓取")
  @PatchMapping("manualGrab")
  public Result manualGrab(@RequestBody GrabRuleDto dto) {
    try {
      this.grabRuleService.manualGrab(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除抓单规则
   *
   * @param ids 抓单规则id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.grabRuleService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用抓单规则
   *
   * @param ids 抓单规则id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.grabRuleService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用抓单规则
   *
   * @param ids 抓单规则id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.grabRuleService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
