package com.biz.crm.kms.business.grab.rule.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRulePageDto;
import com.biz.crm.kms.business.grab.rule.sdk.service.GrabRuleVoService;
import com.biz.crm.kms.business.grab.rule.sdk.vo.GrabRuleVo;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 抓单规则: GrabRuleVo: 抓单规则配置
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Slf4j
@RestController
@RequestMapping("/v1/grabRule/grabRule")
@Api(tags = "抓单规则: GrabRuleVo: 抓单规则配置")
public class GrabRuleVoController {

  @Autowired
  private GrabRuleVoService grabRuleVoService;

  /**
   * 通过ID获取抓单规则详细信息
   *
   * @param id 抓单规则ID
   * @return 抓单规则信息
   */
  @ApiOperation(value = "通过ID获取抓单规则详细信息")
  @GetMapping("/findById")
  public Result<GrabRuleVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<GrabRuleVo> list = this.grabRuleVoService.findByIds(Sets.newHashSet(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 抓单规则分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 抓单规则分页数据
   */
  @ApiOperation(value = "抓单规则分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<GrabRuleVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                 @ApiParam(name = "GrabRulePageDto", value = "分页Dto") GrabRulePageDto dto) {
    try {
      return Result.ok(this.grabRuleVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
