package com.biz.crm.kms.business.grab.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 抓单请求类
 *
 * @author ning.zhang
 * @date 2022/9/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "GrabRequestEntity", description = "抓单请求类")
@Entity
@TableName("kms_grab_request")
@Table(name = "kms_grab_request")
@org.hibernate.annotations.Table(appliesTo = "kms_grab_request", comment = "抓单请求表")
public class GrabRequestEntity extends TenantOpEntity {

  private static final long serialVersionUID = 3303212833298108655L;

  /**
   * 请求GRPC的信息
   */
  @ApiModelProperty("请求GRPC的信息")
  @Column(name = "request", length = 5000, columnDefinition = "VARCHAR(5000) COMMENT '请求GRPC的信息'")
  private String request;

  /**
   * 抓取发起时间
   */
  @ApiModelProperty("抓取发起时间")
  @Column(name = "time", columnDefinition = "datetime COMMENT '抓取发起时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date time;

  /**
   * 是否为自动抓单（1-自动抓单，0-手动抓单）
   */
  @ApiModelProperty("是否为自动抓单（1-自动抓单，0-手动抓单）")
  @Column(name = "auto", length = 3, columnDefinition = "INT(3) COMMENT '是否为自动抓单（1-自动抓单，0-手动抓单）'")
  private Integer auto;

  /**
   * 失败次数
   */
  @ApiModelProperty("失败次数")
  @Column(name = "fail", length = 10, columnDefinition = "INT(10) COMMENT '失败次数'")
  private Integer fail;

  /**
   * 抓取的结果
   */
  @ApiModelProperty("抓取的结果")
  @Column(name = "response", columnDefinition = "VARCHAR(512) COMMENT '抓取的结果'")
  private String response;

  /**
   * 0-单线程，1-多线程
   */
  @ApiModelProperty("0-单线程，1-多线程")
  @Column(name = "method", length = 3, columnDefinition = "INT(3) COMMENT '0-单线程，1-多线程'")
  private Integer method;

  /**
   * 0-数据，1-文件
   */
  @ApiModelProperty("0-数据，1-文件")
  @Column(name = "file", length = 3, columnDefinition = "INT(3) COMMENT '0-数据，1-文件'")
  private Integer file;

  /**
   * UUID(PYTHON抓单需要字段)
   */
  @ApiModelProperty("UUID(PYTHON抓单需要字段)")
  @Column(name = "uuid", columnDefinition = "VARCHAR(255) COMMENT 'UUID(PYTHON抓单需要字段)'")
  private String uuid;
  /**
   * UUID(日志需要字段)
   */
  @ApiModelProperty("uuidLog(日志需要字段)")
  @Column(name = "uuid_log", columnDefinition = "VARCHAR(255) COMMENT 'uuid_log(日志需要字段)'")
  private String uuidLog;
}
