package com.biz.crm.kms.business.grab.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.kms.business.grab.rule.sdk.enums.GrabType;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 抓单规则类
 *
 * @author ning.zhang
 * @date 2022/9/26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "GrabRuleEntity", description = "抓单规则类")
@Entity
@TableName("kms_grab_rule")
@Table(name = "kms_grab_rule", indexes = {
    @Index(name = "kms_grab_rule_index1", columnList = "tenant_code"),
    @Index(name = "kms_grab_rule_index2", columnList = "direct_code"),
    @Index(name = "kms_grab_rule_index3", columnList = "account"),
})
@org.hibernate.annotations.Table(appliesTo = "kms_grab_rule", comment = "抓单规则表")
public class GrabRuleEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -6742504558653128367L;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 客户账号
   */
  @ApiModelProperty("客户账号")
  @Column(name = "account", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户账号'")
  private String account;

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称")
  @Column(name = "rule_name", columnDefinition = "VARCHAR(255) COMMENT '规则名称'")
  private String ruleName;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  @Column(name = "order_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '单据类型'")
  private String orderType;


  /**
   * 开始时间(HH:MM)
   */
  @ApiModelProperty("开始时间(HH:MM)")
  @Column(name = "start_time", length = 32, columnDefinition = "VARCHAR(32) COMMENT '开始时间(HH:MM)'")
  private String startTime;

  /**
   * 结束时间(HH:MM)
   */
  @ApiModelProperty("结束时间(HH:MM)")
  @Column(name = "end_time", length = 32, columnDefinition = "VARCHAR(32) COMMENT '结束时间(HH:MM)'")
  private String endTime;

  /**
   * 时间间隔
   */
  @ApiModelProperty("时间间隔")
  @Column(name = "interval_time", length = 5, columnDefinition = "INT(5) COMMENT '时间间隔'")
  private Integer intervalTime;


  /**
   * 是否是全部门店(Y:是,N:否)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否是全部门店(Y:是,N:否)")
  @Column(name = "all_store_flag", length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否是全部门店(Y:是,N:否)'")
  private String allStoreFlag;

  /**
   * 规则参数(jsonArray)
   */
  @ApiModelProperty("规则参数(jsonArray)")
  @Column(name = "rule_param", length = 5000, columnDefinition = "TEXT(5000) COMMENT '规则参数(jsonArray)'")
  private String ruleParam;

  /**
   * 定时任务执行时间(日期时间格式)
   */
  @ApiModelProperty("定时任务执行时间(日期时间格式)")
  @Column(name = "task_time", columnDefinition = "datetime COMMENT '定时任务执行时间(日期时间格式)'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date taskTime;

  /**
   * 定时任务执行时间(时间戳格式)
   */
  @ApiModelProperty("定时任务执行时间(时间戳格式)")
  @Column(name = "task_timestamp", columnDefinition = "BIGINT(20) COMMENT '定时任务执行时间(时间戳格式)'")
  private Long taskTimestamp;

  /**
   * 门店列表
   */
  @ApiModelProperty("门店列表")
  @TableField(exist = false)
  @Transient
  private List<GrabRuleStoreEntity> storeList;

  /**
   * 抓单类型
   * @see com.biz.crm.kms.business.grab.rule.sdk.enums.GrabType
   */
  @ApiModelProperty("抓单类型")
  @TableField(exist = false)
  @Transient
  private String grabType;
}
