package com.biz.crm.kms.business.grab.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 抓单规则门店类
 *
 * @author ning.zhang
 * @date 2022/9/26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "GrabRuleStoreEntity", description = "抓单规则门店类")
@Entity
@TableName("kms_grab_rule_store")
@Table(name = "kms_grab_rule_store", indexes = {
    @Index(name = "kms_grab_rule_store_index1", columnList = "rule_id"),
})
@org.hibernate.annotations.Table(appliesTo = "kms_grab_rule_store", comment = "抓单规则门店表")
public class GrabRuleStoreEntity extends UuidOpEntity {

  private static final long serialVersionUID = 4220514988492072595L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  @Column(name = "rule_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则ID'")
  private String ruleId;

  /**
   * 门店编码
   */
  @ApiModelProperty("门店编码")
  @Column(name = "store_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '门店编码'")
  private String storeCode;

}
